/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.util.ArrayTagList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class FileTagList
extends ArrayTagList {
    private AbstractFile file;

    public FileTagList(File f) {
        this.setup(new FileAbstractFile(f));
    }

    public FileTagList(AbstractFile f) {
        this.setup(f);
    }

    protected void setup(AbstractFile f) {
        this.file = f;
        this.refresh(true);
    }

    @Override
    public boolean valid() {
        if (this.file.isFile()) {
            return this.file.getFile().isFile();
        }
        return this.file.getLastModified() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean soft) {
        this.clear();
        if (this.valid()) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(this.file.getInputStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    this.add(line);
                }
            }
            catch (IOException ex) {
                System.out.println("ERROR in " + this.file + ": " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        if (!this.file.isFile()) {
            throw new UnsupportedOperationException("save on URL");
        }
        try (PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(this.file.getFile())));){
            for (String c : this) {
                w.println(c);
            }
        }
    }
}

