/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.util.HashList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HashMandelList
extends HashList<QualifiedMandelName>
implements MandelList {
    private final Map<MandelName, List<QualifiedMandelName>> map = new HashMap<MandelName, List<QualifiedMandelName>>();

    public HashMandelList() {
    }

    public HashMandelList(List<QualifiedMandelName> list) {
        this.addAll(list);
    }

    @Override
    public void write(OutputStream os, String dst) throws IOException {
        MandelList.IO.write(this, os, dst);
    }

    @Override
    public void read(InputStream is, String src) throws IOException {
        MandelList.IO.read(this, is, src);
    }

    @Override
    public void refresh(boolean soft) {
    }

    @Override
    public void save() throws IOException {
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public QualifiedMandelName get(MandelName n) {
        List<QualifiedMandelName> names = this.map.get(n);
        if (names == null || names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    public List<QualifiedMandelName> getAll(MandelName n) {
        return this.map.get(n);
    }

    @Override
    protected void clearMap() {
        this.map.clear();
    }

    @Override
    protected void addMap(QualifiedMandelName e) {
        MandelName name = e.getMandelName();
        List<QualifiedMandelName> names = this.map.get(name);
        if (names == null) {
            names = new ArrayList<QualifiedMandelName>();
            this.map.put(name, names);
        }
        names.add(e);
    }

    @Override
    protected void removeMap(QualifiedMandelName e) {
        MandelName name = e.getMandelName();
        List<QualifiedMandelName> names = this.map.get(name);
        if (names != null) {
            names.remove(e);
            if (names.isEmpty()) {
                this.map.remove(name);
            }
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof QualifiedMandelName) {
            MandelName name = ((QualifiedMandelName)o).getMandelName();
            List<QualifiedMandelName> names = this.map.get(name);
            return names != null && names.contains(o);
        }
        if (o instanceof MandelName) {
            List<QualifiedMandelName> names = this.map.get((MandelName)o);
            return names != null && !names.isEmpty();
        }
        return false;
    }
}

