/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.util.FileMandelList;
import com.mandelsoft.mand.util.LeafMandelListFolder;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LeafMandelListFolderTree
implements MandelListFolderTree {
    private MandelListFolder root;
    private MandelList list;

    public LeafMandelListFolderTree(String name, MandelList list) {
        this.list = list;
        this.root = new LeafMandelListFolder(this, name, list);
    }

    @Override
    public MandelListFolder getRoot() {
        return this.root;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public void refresh() {
        this.list.refresh(false);
    }

    @Override
    public void read(InputStream is, String src) throws IOException {
        if (src == null) {
            src = this.getRoot().getPath();
        }
        this.list.read(is, src);
    }

    @Override
    public void write(OutputStream os, String dst) throws IOException {
        if (dst == null) {
            dst = this.getRoot().getPath();
        }
        this.list.write(os, dst);
    }

    @Override
    public void save() throws IOException {
        this.list.save();
    }

    @Override
    public void save(File f) throws IOException {
        FileMandelList fl = new FileMandelList((AbstractFile)new FileAbstractFile(f), this.list);
        fl.save();
    }

    @Override
    public boolean valid() {
        return this.list.valid();
    }
}

