/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MandArith
implements MandelConstants {
    public static final BigDecimal b2 = new BigDecimal(2);
    public static final BigDecimal b0 = new BigDecimal(0);
    public static final BigDecimal b10 = new BigDecimal(10);
    public static final BigDecimal bmin = BigDecimal.valueOf(1L, -450);

    public static BigDecimal mul(BigDecimal a, BigDecimal b) {
        return a.multiply(b, MC);
    }

    public static BigDecimal mul(BigDecimal a, double b) {
        return a.multiply(BigDecimal.valueOf(b), MC);
    }

    public static BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b, MC);
    }

    public static BigDecimal div(BigDecimal a, double b) {
        return a.divide(BigDecimal.valueOf(b), MC);
    }

    public static BigDecimal div(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).divide(b, MC);
    }

    public static BigDecimal div(double a, double b) {
        return BigDecimal.valueOf(a / b);
    }

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        return a.add(b, MC);
    }

    public static BigDecimal add(BigDecimal a, double b) {
        return a.add(BigDecimal.valueOf(b), MC);
    }

    public static BigDecimal sub(BigDecimal a, BigDecimal b) {
        return a.subtract(b, MC);
    }

    public static BigDecimal sub(BigDecimal a, double b) {
        return a.subtract(BigDecimal.valueOf(b), MC);
    }

    public static BigDecimal sub(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).subtract(b, MC);
    }

    static int minScale(BigDecimal d) {
        int s = d.scale();
        while (d.compareTo(BigDecimal.ZERO) != 0) {
            d = d.setScale(d.scale() - 1, RoundingMode.HALF_EVEN);
            --s;
        }
        return s;
    }

    public static BigDecimal round(BigDecimal a, BigDecimal b, int res) {
        return MandArith.round(a, b, res, 1);
    }

    public static BigDecimal round(BigDecimal a, BigDecimal b, int res, int r) {
        b = MandArith.div(b, (double)res);
        int m = MandArith.minScale(b) + 1 + r;
        a = a.setScale(m, RoundingMode.HALF_EVEN);
        if (m < 0 && m > -4) {
            a = a.setScale(0);
        }
        return a;
    }
}

