/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class MandelMathContext {
    protected MathContext ctx;
    protected int precision;

    public MandelMathContext(MandelSpec mi) {
        this.setPrecision(mi);
    }

    public MandelMathContext(int p) {
        this.setPrecision(p);
    }

    public MandelMathContext(int rx, int ry, BigDecimal dx, BigDecimal dy) {
        this.setPrecision(rx, ry, dx, dy);
    }

    public final void setPrecision(MandelSpec mi) {
        this.setPrecision(mi.getRX(), mi.getRY(), mi.getDX(), mi.getDY());
    }

    public final void setPrecision(int rx, int ry, BigDecimal dx, BigDecimal dy) {
        BigDecimal dX = MandArith.div(dx, (double)rx);
        BigDecimal dY = MandArith.div(dy, (double)ry);
        BigDecimal d = dX;
        if (dX.compareTo(dY) > 0) {
            d = dY;
        }
        this.setPrecision(d);
    }

    public final void setPrecision(int p) {
        this.ctx = new MathContext(p, RoundingMode.HALF_EVEN);
        this.precision = (int)((double)p / Math.log10(2.0));
    }

    static int precisionFor(BigDecimal d) {
        int p = 0;
        while (d.compareTo(BigDecimal.ONE) < 0) {
            ++p;
            d = MandArith.mul(d, BigDecimal.TEN);
        }
        return p + 2;
    }

    public final void setPrecision(BigDecimal d) {
        this.setPrecision(MandelMathContext.precisionFor(d));
    }

    public BigDecimal mul(BigDecimal a, BigDecimal b) {
        return a.multiply(b, this.ctx);
    }

    public BigDecimal mul(BigDecimal a, double b) {
        return a.multiply(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal div(BigDecimal a, BigDecimal b) {
        return a.divide(b, this.ctx);
    }

    public BigDecimal div(BigDecimal a, double b) {
        return a.divide(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal div(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).divide(b, this.ctx);
    }

    public BigDecimal div(double a, double b) {
        return BigDecimal.valueOf(a / b);
    }

    public BigDecimal add(BigDecimal a, BigDecimal b) {
        return a.add(b, this.ctx);
    }

    public BigDecimal add(BigDecimal a, double b) {
        return a.add(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal sub(BigDecimal a, BigDecimal b) {
        return a.subtract(b, this.ctx);
    }

    public BigDecimal sub(BigDecimal a, double b) {
        return a.subtract(BigDecimal.valueOf(b), this.ctx);
    }

    public BigDecimal sub(double a, BigDecimal b) {
        return BigDecimal.valueOf(a).subtract(b, this.ctx);
    }
}

