/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.ElementNameMapper;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.ProxyMandelList;
import com.mandelsoft.util.MappedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MappedMandelList
extends ProxyMandelList {
    private ElementNameMapper mapper;

    public MappedMandelList(MandelList list, ElementNameMapper mapper) {
        super(list);
        this.mapper = mapper;
    }

    @Override
    public void add(int index, QualifiedMandelName element) {
        super.add(index, this.mapper.mapIn(element));
    }

    @Override
    public boolean add(QualifiedMandelName e) {
        return super.add(this.mapper.mapIn(e));
    }

    @Override
    public QualifiedMandelName set(int index, QualifiedMandelName element) {
        return super.set(index, this.mapper.mapIn(element));
    }

    private <T> Collection<T> mapIn(Collection<T> set) {
        ArrayList<QualifiedMandelName> nset = new ArrayList<QualifiedMandelName>();
        boolean mapped = false;
        for (T h : set) {
            QualifiedMandelName n = this.mapper.mapIn((QualifiedMandelName)h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    @Override
    public boolean addAll(int index, Collection<? extends QualifiedMandelName> c) {
        return super.addAll(index, this.mapIn(c));
    }

    @Override
    public boolean addAll(Collection<? extends QualifiedMandelName> c) {
        return super.addAll(this.mapIn(c));
    }

    private Collection<?> mapFilteredIn(Collection<?> set) {
        ArrayList<QualifiedMandelName> nset = new ArrayList<QualifiedMandelName>();
        boolean mapped = false;
        for (Object o : set) {
            if (o instanceof QualifiedMandelName) {
                try {
                    QualifiedMandelName n = this.mapper.mapIn((QualifiedMandelName)o);
                    nset.add(n);
                    mapped |= n != o;
                }
                catch (IllegalArgumentException ex) {
                    mapped = true;
                }
                continue;
            }
            mapped = true;
        }
        return mapped ? nset : set;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(this.mapFilteredIn(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(this.mapFilteredIn(c));
    }

    private List<QualifiedMandelName> mapOut(List<QualifiedMandelName> set) {
        ArrayList<QualifiedMandelName> nset = new ArrayList<QualifiedMandelName>();
        boolean mapped = false;
        for (QualifiedMandelName h : set) {
            QualifiedMandelName n = this.mapper.mapOut(h);
            nset.add(n);
            mapped |= n != h;
        }
        return mapped ? nset : set;
    }

    private <T> T[] mapOut(T[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mapper.mapOut((QualifiedMandelName)array[i]);
        }
        return array;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof QualifiedMandelName) {
            return super.contains(this.mapper.mapIn((QualifiedMandelName)o));
        }
        return false;
    }

    @Override
    public QualifiedMandelName get(int index) {
        QualifiedMandelName n = super.get(index);
        if (n == null) {
            return null;
        }
        return this.mapper.mapOut(n);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof QualifiedMandelName) {
            return super.indexOf(this.mapper.mapIn((QualifiedMandelName)o));
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof QualifiedMandelName) {
            return super.lastIndexOf(this.mapper.mapIn((QualifiedMandelName)o));
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof QualifiedMandelName) {
            return super.remove(this.mapper.mapIn((QualifiedMandelName)o));
        }
        return false;
    }

    @Override
    public List<QualifiedMandelName> subList(int fromIndex, int toIndex) {
        return this.mapOut(super.subList(fromIndex, toIndex));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mapOut(super.toArray(a));
    }

    @Override
    public Object[] toArray() {
        return this.mapOut(super.toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            c = this.mapIn(c);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return super.containsAll(c);
    }

    @Override
    public Iterator<QualifiedMandelName> iterator() {
        return new MappedIterator<QualifiedMandelName, QualifiedMandelName>(super.iterator()){

            @Override
            protected QualifiedMandelName map(QualifiedMandelName elem) {
                return MappedMandelList.this.mapper.mapOut(elem);
            }
        };
    }

    @Override
    public ListIterator<QualifiedMandelName> listIterator(int index) {
        return new MappedListIterator(super.listIterator(index));
    }

    @Override
    public ListIterator<QualifiedMandelName> listIterator() {
        return new MappedListIterator(super.listIterator());
    }

    private class MappedListIterator
    implements ListIterator<QualifiedMandelName> {
        private ListIterator<QualifiedMandelName> it;

        public MappedListIterator(ListIterator<QualifiedMandelName> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public QualifiedMandelName next() {
            QualifiedMandelName n = this.it.next();
            if (n == null) {
                return n;
            }
            return MappedMandelList.this.mapper.mapOut(n);
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public QualifiedMandelName previous() {
            QualifiedMandelName n = this.it.previous();
            if (n == null) {
                return n;
            }
            return MappedMandelList.this.mapper.mapOut(n);
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(QualifiedMandelName e) {
            this.it.set(MappedMandelList.this.mapper.mapIn(e));
        }

        @Override
        public void add(QualifiedMandelName e) {
            this.it.add(MappedMandelList.this.mapper.mapIn(e));
        }
    }
}

