/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util.lists;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.lists.AbstractDeadEndFactory;
import java.io.IOException;

public class PendingWorkFactory
extends AbstractDeadEndFactory {
    public PendingWorkFactory(MandelScanner scanner, MandelName basename) {
        super(scanner, basename, "Pending Work");
    }

    @Override
    protected boolean accept(QualifiedMandelName n) {
        return super.accept(n) && !this.hasMandel(n);
    }

    @Override
    protected boolean hasMandel(QualifiedMandelName n) {
        MandelHandle h = this.getScanner().getMandelInfo(n);
        if (h != null) {
            try {
                MandelData md = h.getInfo();
                MandelInfo mi = md.getInfo();
                long nm = mi.getMCnt();
                long np = mi.getRX() * mi.getRY();
                if ((double)(nm * 100L) / (double)np > 0.1) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

