/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.Corner;
import com.mandelsoft.swing.Dimensions;
import com.mandelsoft.swing.RenewStateListener;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BufferedFrame
extends JFrame {
    public static boolean debug = false;
    public static final int FRAME_INSETS = 5;
    private BufferedComponent buffer;
    private JScrollPane scrollpane;
    private boolean partial = false;
    private List<RenewStateListener> listeners = new ArrayList<RenewStateListener>();

    public BufferedFrame() {
        this(new BufferedComponent());
    }

    public BufferedFrame(int width, int height) {
        this(new BufferedComponent(width, height));
    }

    public BufferedFrame(BufferedComponent c) {
        this.buffer = c;
        this.scrollpane = new JScrollPane(c);
        this.scrollpane.setBorder(null);
        this.add(this.scrollpane);
        this.pack();
        c.setLimitWindowSize(true);
        this.scrollpane.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JViewport vp = BufferedFrame.this.scrollpane.getViewport();
                if (vp != null) {
                    if (debug) {
                        System.out.println("PREF:" + BufferedFrame.this.buffer.getPreferredSize());
                    }
                    if (debug) {
                        System.out.println("VP: " + vp.getViewPosition());
                    }
                    if (debug) {
                        System.out.println("VP: " + vp.getExtentSize());
                    }
                    BufferedFrame.this.partial = !BufferedFrame.this.buffer.getPreferredSize().equals(vp.getExtentSize());
                } else {
                    BufferedFrame.this.partial = false;
                }
            }
        });
    }

    public BufferedFrame(BufferedImage image) {
        this(new BufferedComponent(image));
    }

    public boolean isPartial() {
        return this.partial;
    }

    public BufferedComponent getImagePane() {
        return this.buffer;
    }

    public JScrollPane getScrollPane() {
        return this.scrollpane;
    }

    public void setInitialSize() {
        Dimension id = this.buffer.getPreferredSize();
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = new Dimension(id);
        Insets insets = this.getInsets();
        Dimensions.mod.add(d, insets.left + insets.right, insets.top + insets.bottom);
        Dimensions.mod.sub(sd, 5.0, 5.0);
        Dimensions.mod.limit(d, sd);
        this.setSize(d);
    }

    public void setImage(BufferedImage image) {
        if (debug) {
            System.out.println("image to buffer");
        }
        this.buffer.setImage(image);
        this.buffer.setScale(1.0);
        if (debug) {
            System.out.println("image buffer set");
        }
    }

    public void setComponentPopupMenu(JPopupMenu menu) {
        this.buffer.setComponentPopupMenu(menu);
    }

    public void showAllRects() {
        this.buffer.showAllRects();
    }

    public BufferedComponent.VisibleRect createRect(String name, Object o) {
        return this.buffer.createRect(name, o);
    }

    public void setSelectInvisible(boolean b) {
        this.buffer.setSelectInvisible(b);
    }

    public void setRectangleSelector(BufferedComponent.RectangleSelector s) {
        this.buffer.setRectangleSelector(s);
    }

    public void setLimitWindowSize(boolean b) {
        this.buffer.setLimitWindowSize(b);
    }

    public void removeRectModifiedEventListener(BufferedComponent.RectModifiedEventListener l) {
        this.buffer.removeRectModifiedEventListener(l);
    }

    public void removeRectEventListener(BufferedComponent.RectEventListener l) {
        this.buffer.removeRectEventListener(l);
    }

    public void removeCornerEventListener(BufferedComponent.RectPointEventListener l) {
        this.buffer.removeRectPointEventListener(l);
    }

    public void removeActionListener(ActionListener l, Corner c) {
        this.buffer.removeActionListener(l, c);
    }

    public void discardAllRects() {
        this.buffer.discardAllRects();
    }

    public void addRectModifiedEventListener(BufferedComponent.RectModifiedEventListener l) {
        this.buffer.addRectModifiedEventListener(l);
    }

    public void addRectEventListener(BufferedComponent.RectEventListener l) {
        this.buffer.addRectEventListener(l);
    }

    public void addCornerEventListener(BufferedComponent.RectPointEventListener l) {
        this.buffer.addRectPointEventListener(l);
    }

    public void addActionListener(ActionListener l, Corner c) {
        this.buffer.addActionListener(l, c);
    }

    public Graphics2D createGraphics() {
        return this.buffer.createGraphics();
    }

    @Override
    public void revalidate() {
        this.buffer.revalidate();
    }

    public int translateY(MouseEvent e) {
        return this.buffer.translateY(e);
    }

    public int translateY(int y) {
        return this.buffer.translateY(y);
    }

    public int translateX(MouseEvent e) {
        return this.buffer.translateX(e);
    }

    public int translateX(int x) {
        return this.buffer.translateX(x);
    }

    public MouseEvent translate(MouseEvent e) {
        return this.buffer.translate(e);
    }

    public void addRenewStateListener(RenewStateListener l) {
        this.listeners.add(l);
    }

    public void removeRenewStateListener(RenewStateListener l) {
        this.listeners.remove(l);
    }

    protected void fireRenewState() {
        for (RenewStateListener l : this.listeners) {
            try {
                l.renewState(this);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

