/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.ITreeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IJTree
extends JTree {
    private TreeModel origModel;

    public IJTree(TreeModel newModel) {
        super(newModel);
        this._setupIJTree();
    }

    public IJTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this._setupIJTree();
    }

    public IJTree(TreeNode root) {
        super(root);
        this._setupIJTree();
    }

    public IJTree(Hashtable<?, ?> value) {
        super(value);
        this._setupIJTree();
    }

    public IJTree(Vector<?> value) {
        super(value);
        this._setupIJTree();
    }

    public IJTree(Object[] value) {
        super(value);
        this._setupIJTree();
    }

    public IJTree() {
        this._setupIJTree();
    }

    private void _setupIJTree() {
        this.addPropertyChangeListener("ancestor", new ComponentPropertyListener());
    }

    protected void componentBound() {
        if (this.origModel != null && this.treeModel == null) {
            this.treeModel = this.origModel;
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
            if (this.accessibleContext != null) {
                this.treeModel.addTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
            this.origModel = null;
        }
    }

    protected void componentUnbound() {
        this.origModel = this.treeModel;
        this.treeModel = null;
        if (this.origModel != null) {
            if (this.treeModelListener != null) {
                this.origModel.removeTreeModelListener(this.treeModelListener);
            }
            if (this.accessibleContext != null) {
                this.treeModel.removeTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
        }
    }

    @Override
    public ITreeModel getModel() {
        return (ITreeModel)super.getModel();
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.setModel((ITreeModel)newModel);
    }

    public void setModel(ITreeModel newModel) {
        super.setModel(newModel);
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ITreeModel m = this.getModel();
        if (m == null) {
            return "";
        }
        return m.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return this.getModel().isPathEditable(path);
    }

    private class ComponentPropertyListener
    implements PropertyChangeListener {
        private ComponentPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == null) {
                IJTree.this.componentUnbound();
            } else {
                IJTree.this.componentBound();
            }
        }
    }

    public static class DefaultModel
    extends DefaultTreeModel
    implements ITreeModel {
        private boolean modifiable = false;

        public DefaultModel(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
        }

        public DefaultModel(TreeNode root) {
            super(root);
        }

        public boolean isModifiable() {
            return this.modifiable;
        }

        public void setModifiable(boolean modifiable) {
            this.modifiable = modifiable;
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return value.toString();
        }

        @Override
        public boolean isPathEditable(TreePath path) {
            return this.isModifiable();
        }
    }
}

