/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Utils {
    public static <T> T convertValueToValueClass(Object value, Class<T> valueClass) {
        if (value == null) {
            return null;
        }
        if (valueClass != null) {
            if (valueClass.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            if (value instanceof Number) {
                if (valueClass == Integer.class) {
                    return (T)new Integer(((Number)value).intValue());
                }
                if (valueClass == Long.class) {
                    return (T)new Long(((Number)value).longValue());
                }
                if (valueClass == Float.class) {
                    return (T)new Float(((Number)value).floatValue());
                }
                if (valueClass == Double.class) {
                    return (T)new Double(((Number)value).doubleValue());
                }
                if (valueClass == Byte.class) {
                    return (T)new Byte(((Number)value).byteValue());
                }
                if (valueClass == Short.class) {
                    return (T)new Short(((Number)value).shortValue());
                }
                if (valueClass == BigDecimal.class) {
                    if (value instanceof BigInteger) {
                        return (T)new BigDecimal((BigInteger)value);
                    }
                    return (T)new BigDecimal(((Number)value).doubleValue());
                }
                if (valueClass == BigInteger.class) {
                    return (T)BigInteger.valueOf(((Number)value).longValue());
                }
            }
            for (Constructor<?> cr : valueClass.getConstructors()) {
                Class<?>[] params = cr.getParameterTypes();
                if (params == null || params.length != 1 || !params[0].isAssignableFrom(value.getClass())) continue;
                try {
                    return valueClass.getConstructor(params).newInstance(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("inconvertibe types: " + value.getClass() + "/" + valueClass);
        }
        return (T)value;
    }
}

