/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

public interface IntMatrix {
    public int getData(int var1, int var2);

    public void setData(int var1, int var2, int var3);

    public int getRX();

    public int getRY();

    public static int[][] asArray(IntMatrix m) {
        int rx = m.getRX();
        int ry = m.getRY();
        int[][] matrix = new int[ry][rx];
        for (int y = 0; y < ry; ++y) {
            for (int x = 0; x < rx; ++x) {
                matrix[y][x] = m.getData(x, y);
            }
        }
        return matrix;
    }

    public static void copy(IntMatrix from, IntMatrix to) {
        int rx = from.getRX();
        int ry = from.getRY();
        for (int y = 0; y < ry; ++y) {
            for (int x = 0; x < rx; ++x) {
                to.setData(x, y, from.getData(x, y));
            }
        }
    }

    public static class Memory
    implements IntMatrix {
        private int[][] buffer;
        private int rx;
        private int ry;

        public Memory(int rx, int ry) {
            this.buffer = new int[ry][rx];
            this.rx = rx;
            this.ry = ry;
        }

        public Memory(IntMatrix m) {
            this.rx = m.getRX();
            this.ry = m.getRY();
            this.buffer = IntMatrix.asArray(m);
        }

        @Override
        public int getData(int x, int y) {
            return this.buffer[y][x];
        }

        @Override
        public void setData(int x, int y, int val) {
            this.buffer[y][x] = val;
        }

        @Override
        public int getRX() {
            return this.rx;
        }

        @Override
        public int getRY() {
            return this.ry;
        }
    }
}

