/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA1FingerPrint {
    private MessageDigest md = MessageDigest.getInstance("SHA-1");

    public void update(byte[] bytes, int start, int len) {
        this.md.update(bytes, start, len);
    }

    public void update(byte[] bytes) {
        this.md.update(bytes);
    }

    public void update(String text) throws UnsupportedEncodingException {
        this.md.update(text.getBytes("utf-8"));
    }

    private static char halfByte(int halfbyte) {
        if (0 <= halfbyte && halfbyte <= 9) {
            return (char)(48 + halfbyte);
        }
        return (char)(65 + (halfbyte - 10));
    }

    public String getSHA1() {
        byte[] sha1hash = new byte[40];
        sha1hash = this.md.digest();
        return SHA1FingerPrint.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buf.append(SHA1FingerPrint.halfByte(data[i] >> 4 & 0xF));
            buf.append(SHA1FingerPrint.halfByte(data[i] & 0xF));
        }
        return buf.toString();
    }

    public static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("utf-8"), 0, text.length());
        sha1hash = md.digest();
        return SHA1FingerPrint.convertToHex(sha1hash);
    }

    public static void main(String[] args) {
        String expected = "AFB3AB0688399BE23A3833B447F04F3C0420DC68";
        String text = "This ia a simple demo text";
        try {
            String sha1 = SHA1FingerPrint.SHA1(text);
            System.out.println("SHA1: " + sha1);
            if (!sha1.equals(expected)) {
                System.err.println("Failed: expected " + expected);
            }
            SHA1FingerPrint fp = new SHA1FingerPrint();
            fp.update(text);
            sha1 = fp.getSHA1();
            System.out.println("SHA1: " + sha1);
            if (!sha1.equals(expected)) {
                System.err.println("Failed: expected " + expected);
            }
        }
        catch (Exception ex) {
            System.err.println("failed " + ex);
        }
    }
}

