/*
 * Decompiled with CFR 0.152.
 */
package playground;

import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigExpDouble {
    double mantisse;
    int exponent;

    public BigExpDouble(double m, int e) {
        int exp = Math.getExponent(m);
        this.mantisse = Math.scalb(m, -exp);
        this.exponent = e + exp;
    }

    public BigExpDouble(double m) {
        int e = Math.getExponent(m);
        this.mantisse = Math.scalb(m, -Math.getExponent(m));
        this.exponent = e;
    }

    public BigExpDouble(BigDecimal b) {
        double m;
        b = b.stripTrailingZeros();
        String s = b.unscaledValue().toString();
        int exp = b.scale() - s.length();
        double f = Math.log(10.0) / Math.log(2.0) * (double)(-exp);
        int e = (int)Math.floor(f);
        this.mantisse = m = b.scaleByPowerOfTen(exp).doubleValue() * Math.pow(2.0, f - (double)e);
        this.exponent = e;
    }

    public String toString() {
        BigDecimal m = new BigDecimal(this.mantisse);
        m = MandArith.mul(m, MandArith.b2.pow(this.exponent, MandArith.MC));
        return m.round(new MathContext(16)).toString();
    }

    public double toDouble() {
        return this.mantisse * Math.pow(2.0, this.exponent);
    }

    public BigExpDouble mul(BigExpDouble v) {
        double m = this.mantisse * v.mantisse;
        int e = this.exponent + v.exponent;
        return new BigExpDouble(m, e);
    }

    public BigExpDouble div(BigExpDouble v) {
        double m = this.mantisse / v.mantisse;
        int e = this.exponent - v.exponent;
        return new BigExpDouble(m, e);
    }

    public BigExpDouble add(BigExpDouble v) {
        int e;
        double m;
        if (this.exponent >= v.exponent) {
            m = this.mantisse + Math.scalb(v.mantisse, v.exponent - this.exponent);
            e = this.exponent;
        } else {
            m = v.mantisse + Math.scalb(this.mantisse, this.exponent - v.exponent);
            e = v.exponent;
        }
        return new BigExpDouble(m, e);
    }

    public BigExpDouble sub(BigExpDouble v) {
        int e;
        double m;
        if (this.exponent >= v.exponent) {
            m = this.mantisse - Math.scalb(v.mantisse, v.exponent - this.exponent);
            e = this.exponent;
        } else {
            m = Math.scalb(this.mantisse, this.exponent - v.exponent) - v.mantisse;
            e = v.exponent;
        }
        return new BigExpDouble(m, e);
    }

    public boolean lt(BigExpDouble v) {
        if (this.exponent == v.exponent) {
            return this.mantisse < v.mantisse;
        }
        return this.exponent < v.exponent;
    }

    public boolean gt(BigExpDouble v) {
        if (this.exponent == v.exponent) {
            return this.mantisse > v.mantisse;
        }
        return this.exponent > v.exponent;
    }

    public static void test(double d) {
        System.out.printf("%g: %d %g\n", d, Math.getExponent(d), Math.scalb(d, -Math.getExponent(d)));
    }

    public static void math(double a, double b) {
        BigExpDouble ba = new BigExpDouble(a);
        BigExpDouble bb = new BigExpDouble(b);
        System.out.printf("%g * %g = %g\n", a, b, a * b);
        System.out.printf("%s * %s = %s\n", ba, bb, ba.mul(bb));
        System.out.printf("%g / %g = %g\n", a, b, a / b);
        System.out.printf("%s / %s = %s\n", ba, bb, ba.div(bb));
        System.out.printf("%g + %g = %g\n", a, b, a + b);
        System.out.printf("%s + %s = %s\n", ba, bb, ba.add(bb));
        System.out.printf("%g - %g = %g\n", a, b, a - b);
        System.out.printf("%s - %s = %s\n", ba, bb, ba.sub(bb));
    }

    public static void convert(double a) {
        BigDecimal b = new BigDecimal(a, MandArith.MC);
        System.out.printf("%g: %s (%d) %s\n", a, b, b.scale(), b.unscaledValue());
        BigExpDouble bd = new BigExpDouble(b);
        System.out.printf("    %s\n", bd);
    }

    public static void convert(BigDecimal b) {
        System.out.printf("%s:(%d) %s\n", b, b.scale(), b.unscaledValue());
        BigExpDouble bd = new BigExpDouble(b);
        System.out.printf("    %s\n", bd);
    }

    public static void main(String[] args) {
        System.out.println("test");
        BigExpDouble.test(1.0);
        BigExpDouble.test(2.0);
        BigExpDouble.test(4.0);
        BigExpDouble.test(8.0);
        BigExpDouble.test(10.0);
        BigExpDouble.test(64.0);
        BigExpDouble.test(64.5);
        BigExpDouble.test(100.0);
        BigExpDouble.test(1.234);
        BigExpDouble.test(147.264534);
        BigExpDouble.test(1.0E308);
        BigExpDouble.math(8.0, 2.0);
        BigExpDouble.math(2.0, 8.0);
        BigExpDouble.math(10.0, 100.0);
        BigExpDouble.math(3.145, 100.0);
        BigExpDouble.math(1.0E308, 1.0E308);
        BigExpDouble.convert(64.0);
        BigExpDouble.convert(0.25);
        BigExpDouble.convert(1.0E10);
        BigExpDouble.convert(1.0E300);
        BigExpDouble.convert(-20.0);
        BigExpDouble.convert(-0.125);
        BigExpDouble.convert(new BigDecimal(1.0E300, MandArith.MC).multiply(new BigDecimal(1.0E300, MandArith.MC)));
    }
}

