/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.io;

import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.io.URLAbstractFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;

public interface AbstractFile {
    public boolean isFile();

    public InputStream getInputStream() throws IOException;

    public long getLastModified();

    public URL getURL();

    public Proxy getProxy();

    public File getFile();

    public String getPath();

    public String getName();

    public boolean lock() throws IOException;

    public boolean tryLock() throws IOException;

    public void releaseLock() throws IOException;

    public AbstractFile getParent();

    public AbstractFile getSub(String var1);

    public static class Factory {
        public static AbstractFile create(File f) {
            return new FileAbstractFile(f);
        }

        public static AbstractFile create(File folder, String name) {
            return new FileAbstractFile(new File(folder, name));
        }

        public static AbstractFile create(Proxy proxy, URL url, long lastModified) {
            return new URLAbstractFile(proxy, url, lastModified);
        }

        public static AbstractFile create(Proxy proxy, URL url) {
            return new URLAbstractFile(proxy, url);
        }

        public static AbstractFile create(String path, Proxy proxy, boolean local) {
            try {
                URL url = new URL(path);
                if (url.getProtocol().equals("file")) {
                    if (!local) {
                        throw new RuntimeException("file paths not allowed for remote repositories");
                    }
                    return Factory.create(new File(url.getPath()));
                }
                return Factory.create(proxy, url);
            }
            catch (MalformedURLException ex) {
                if (!local) {
                    throw new RuntimeException("file paths not allowed for remote repositories");
                }
                return Factory.create(new File(path));
            }
        }
    }
}

