/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.image;

import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.awt.Color;
import java.awt.image.ColorModel;

public class ColorMapper
extends StateChangeSupport {
    public static boolean debug = false;
    private ColorModel colormodel;
    private Colormap colormap;
    private Mapping mapping;
    private Colormap.ChangeHandler handler = new Colormap.ChangeHandler(){

        public void handle(Colormap cm) {
            ColorMapper.this.updateColorMapping();
        }
    };
    private Object[] colormapping;

    public ColorMapper(ColorModel colmod, Colormap colmap, Mapping m) {
        this.colormodel = colmod;
        this.setColormap(colmap);
        this.setMapping(m);
    }

    public void setColormap(Colormap colmap) {
        if (this.colormap == colmap) {
            return;
        }
        if (this.mapping != null && colmap != null && colmap.getSize() != this.mapping.getTargetSize()) {
            throw new MandelException("illegal colormap size: " + colmap.getSize() + "!=" + this.mapping.getTargetSize());
        }
        if (this.colormap != null) {
            this.colormap.removeChangeListener(this.handler);
        }
        this.colormap = colmap;
        if (debug) {
            System.out.println("setting colormap for image " + colmap);
        }
        if (this.colormodel != null && this.colormap != null) {
            this.updateColorMapping();
            this.colormap.addChangeListener(this.handler);
        }
    }

    public void setMapping(Mapping map) {
        if (map != null && this.colormap != null && map.getTargetSize() > this.colormap.getSize()) {
            throw new MandelException("illegal target size: " + map.getTargetSize() + ">" + this.colormap.getSize());
        }
        if (!this.equals(this.mapping, map)) {
            this.mapping = map;
            this.fireChangeEvent();
        }
    }

    public void setData(Colormap colmap, Mapping map) {
        boolean mod2 = false;
        if (map != null && colmap != null && map.getTargetSize() > colmap.getSize()) {
            throw new MandelException("illegal target size: " + map.getTargetSize() + ">" + colmap.getSize());
        }
        if (!this.equals(this.mapping, map)) {
            mod2 = true;
            this.mapping = map;
        }
        if (this.colormap != colmap) {
            mod2 = true;
            if (this.colormap != null) {
                this.colormap.removeChangeListener(this.handler);
            }
            this.colormap = colmap;
            if (this.colormap != null) {
                if (this.colormodel != null) {
                    this.updateColorMapping();
                }
                this.colormap.addChangeListener(this.handler);
            }
        }
        if (mod2) {
            this.fireChangeEvent();
        }
    }

    private boolean equals(Mapping a, Mapping b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private void updateColorMapping() {
        if (this.colormapping == null || this.colormapping.length != this.colormap.getSize()) {
            this.colormapping = new Object[this.colormap.getSize()];
        }
        for (int i = 0; i < this.colormap.getSize(); ++i) {
            int rgb = this.colormap.getColor(i).getRGB();
            this.colormapping[i] = this.colormodel.getDataElements(rgb, this.colormapping[i]);
        }
        this.fireChangeEvent();
    }

    public void fireChangeEvent() {
        if (this.mapping != null && this.colormap != null) {
            super.fireChangeEvent();
        }
    }

    public int mapColormapIndex(int it) {
        return this.mapping.getColormapIndex(it);
    }

    public Color mapIterationValue(int it) {
        try {
            int ci = this.mapColormapIndex(it);
            return this.colormap.getColor(ci);
        }
        catch (NullPointerException npe) {
            if (this.mapping == null) {
                throw new MandelException("no mapping set");
            }
            throw new MandelException("no colormap set");
        }
    }

    public int mapIterationValueToRGB(int it) {
        return this.mapIterationValue(it).getRGB();
    }

    public Object mapIterationValueToDataElements(int it) {
        int ci;
        try {
            ci = this.mapping.getColormapIndex(it);
        }
        catch (NullPointerException npe) {
            throw new MandelException("no mapping set");
        }
        try {
            return this.colormapping[ci];
        }
        catch (NullPointerException npe) {
            if (this.colormap != null) {
                throw new MandelException("no color model set");
            }
            throw new MandelException("no colormap set");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.colormap != null) {
            this.colormap.removeChangeListener(this.handler);
        }
    }

    public static abstract class ChangeHandler
    implements ChangeListener {
        public abstract void handle(ColorMapper var1);

        public void stateChanged(ChangeEvent e) {
            this.handle((ColorMapper)e.getSource());
        }
    }
}

