/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.mapping.StatisticMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OptimalMapper
extends StatisticMapper {
    public static final int VERSION = 2;
    private int minarea;
    private int minimize;

    public OptimalMapper() {
        this(10);
    }

    public OptimalMapper(int area) {
        this.minarea = area;
    }

    public OptimalMapper(int area, int minimize) {
        this.minarea = area;
        this.minimize = minimize;
    }

    public String getName() {
        return "Optimal";
    }

    public String getParamDesc() {
        return "a=" + this.minarea + ",m=" + this.minimize + "," + super.getParamDesc();
    }

    public double getMinArea() {
        return this.minarea;
    }

    public boolean isMinimize() {
        return this.minimize != 0;
    }

    public int getMinimize() {
        return this.minimize;
    }

    protected StatisticMapper.BreakCondition createBreakCondition(StatisticMapper.StatisticRasterInfo info) {
        return new AreaCondition(info);
    }

    protected int adjustColmapSize(int colmapsize) {
        if (this.minimize > 0 && colmapsize > this.minimize) {
            colmapsize = this.minimize;
        }
        return colmapsize;
    }

    protected int getDefaultVersion() {
        return 2;
    }

    protected boolean validVersion(int v) {
        return 1 <= v && v <= 2;
    }

    protected void _write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                this.writeV1(dos);
                break;
            }
            case 2: {
                this.writeV2(dos);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeInt(this.minarea);
    }

    protected void writeV2(DataOutputStream dos) throws IOException {
        this.writeV1(dos);
        dos.writeInt(this.minimize);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
        switch (v) {
            case 1: {
                this.readV1(dis);
                break;
            }
            case 2: {
                this.readV2(dis);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.minarea = dis.readInt();
    }

    protected void readV2(DataInputStream dis) throws IOException {
        this.readV1(dis);
        this.minimize = dis.readInt();
    }

    protected class AreaCondition
    implements StatisticMapper.BreakCondition {
        private int size;

        public AreaCondition(StatisticMapper.StatisticRasterInfo info) {
            this.size = OptimalMapper.this.minarea;
        }

        public boolean done(int num, int accu) {
            return accu >= this.size;
        }
    }
}

