/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.mapping.ArrayMapping;
import com.mandelsoft.mand.mapping.BalancedTreeSupport;
import com.mandelsoft.mand.mapping.MapperSupport;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.mand.mapping.MappingBuilder;
import com.mandelsoft.mand.mapping.MappingRepresentation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StatisticMapper
extends MapperSupport {
    public static boolean debug = false;
    public static boolean usebuilder = true;
    public static final int VERSION = 1;
    private double factor;
    private double limit;
    private static boolean hdeb = false;

    public StatisticMapper() {
        this(0.0);
    }

    public StatisticMapper(double factor) {
        this(factor, 1.0);
    }

    public StatisticMapper(double factor, double limit) {
        this.factor = factor;
        this.limit = limit;
    }

    public String getName() {
        return "Statistic";
    }

    public String getParamDesc() {
        return "f=" + this.factor + ",l=" + this.limit;
    }

    public double getFactor() {
        return this.factor;
    }

    public double getLimit() {
        return this.limit;
    }

    public Mapping createMapping(MandelRaster raster, int colmapsize) {
        StatisticRasterInfo info = new StatisticRasterInfo(raster);
        int[] mapping = usebuilder ? null : new int[info.getSize()];
        colmapsize = this.adjustColmapSize(colmapsize);
        MappingBuilder mb = new MappingBuilder(info.getMinIt(), info.getMaxIt(), colmapsize);
        int s = info.compressColors(colmapsize - 1, mapping, mb, this.createBreakCondition(info)) + 1;
        if (debug) {
            System.out.println("MAPPING: " + s);
        }
        MappingRepresentation mr = usebuilder ? (mb.getSourceSize() < 2000000 ? mb.createArrayMapping() : mb.createTreeMapping()) : new ArrayMapping(mapping);
        return new Mapping(mb, mr);
    }

    protected BreakCondition createBreakCondition(StatisticRasterInfo info) {
        return null;
    }

    protected int adjustColmapSize(int colmapsize) {
        return colmapsize;
    }

    protected int getDefaultVersion() {
        return 1;
    }

    protected boolean validVersion(int v) {
        return 1 <= v && v <= 1;
    }

    protected void _write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeDouble(this.factor);
        dos.writeDouble(this.limit);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
        switch (v) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown cyclic mapping version " + v);
            }
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.factor = dis.readDouble();
        this.limit = dis.readDouble();
    }

    public static interface BreakCondition {
        public boolean done(int var1, int var2);
    }

    protected class StatisticRasterInfo
    extends MapperSupport.RasterInfo {
        Histogram histogram;
        int[] points;
        int[] accu;
        int last;

        StatisticRasterInfo(MandelRaster r) {
            super(r);
        }

        protected void analyseRaster(MandelRaster r) {
            super.analyseRaster(r);
            this.histogram = new TreeHistogram(this.getSize());
            int[][] raster = r.getRaster();
            for (int y = 0; y < r.getRY(); ++y) {
                for (int x = 0; x < r.getRX(); ++x) {
                    int i = raster[y][x];
                    if (i <= 0) continue;
                    this.histogram.add(i - this.minIt);
                }
            }
        }

        int histMax() {
            return this.histogram.histMax();
        }

        int setupColors() {
            this.points = new int[this.histogram.getSize()];
            this.accu = new int[this.histogram.getSize()];
            this.last = -1;
            int cnt = 0;
            int cur = this.histogram.getSize() - 1;
            for (int i = this.histogram.getSize() - 1; i >= 0; --i) {
                this.accu[i] = this.histogram.mapIndexToCount(i);
                if (this.accu[i] <= 0) continue;
                if (this.last < 0) {
                    this.last = i;
                } else {
                    this.points[cur] = i;
                }
                cur = i;
                ++cnt;
            }
            this.points[cur] = -1;
            return cnt;
        }

        Pointer minUsedColor(Pointer p) {
            if (p.cnt > 0 && p.min > 0) {
                int cur = this.points[p.prev];
                int prev = p.prev;
                p.cur = cur;
                while (cur >= 0) {
                    if (this.accu[cur] == p.min) {
                        p.cur = cur;
                        p.prev = prev;
                        --p.cnt;
                        return p;
                    }
                    prev = cur;
                    cur = this.points[cur];
                }
            }
            return this._minUsedColor(p);
        }

        Pointer _minUsedColor(Pointer p) {
            int cur = this.points.length - 1;
            int prev = -1;
            p.cur = cur;
            p.prev = prev;
            p.cnt = 0;
            p.min = 0;
            while (cur >= 0) {
                if (this.accu[cur] <= this.accu[p.cur]) {
                    if (this.accu[cur] < this.accu[p.cur]) {
                        p.cur = cur;
                        p.prev = prev;
                        p.min = this.accu[cur];
                        p.cnt = 1;
                    } else {
                        ++p.cnt;
                    }
                }
                prev = cur;
                cur = this.points[cur];
            }
            return p;
        }

        int joinNext(Pointer p) {
            if ((p.cur == 1 || p.prev == 1) && debug) {
                System.out.println("join next " + p.cur);
            }
            int n = p.cur;
            this.accu[n] = this.accu[n] + this.accu[this.points[p.cur]];
            this.points[p.cur] = this.points[this.points[p.cur]];
            return p.cur;
        }

        int joinPrev(Pointer p) {
            if ((p.cur == 1 || p.prev == 1) && debug) {
                System.out.println("join prev " + p.cur + " (" + p.prev + ")");
            }
            int n = p.prev;
            this.accu[n] = this.accu[n] + this.accu[p.cur];
            this.points[p.prev] = this.points[p.cur];
            return p.prev;
        }

        int joinColor(Pointer p) {
            if (this.points[p.cur] < 0) {
                return this.joinPrev(p);
            }
            if (p.prev < 0) {
                return this.joinNext(p);
            }
            if (this.accu[this.points[p.cur]] < this.accu[p.prev]) {
                return this.joinNext(p);
            }
            return this.joinPrev(p);
        }

        int compressColors(int n, int[] mapping, MappingBuilder mb, BreakCondition c) {
            int curidx;
            int num;
            int max = this.histMax();
            int bound = (int)(StatisticMapper.this.limit * (double)max);
            Pointer p = new Pointer();
            for (num = this.setupColors(); num > n; --num) {
                p = this.minUsedColor(p);
                if (c != null && c.done(num, this.accu[p.cur])) break;
                int cur = this.joinColor(p);
                if (bound - this.accu[cur] <= 0) continue;
                int n2 = cur;
                this.accu[n2] = (int)((double)this.accu[n2] + (double)(bound - this.accu[cur]) * StatisticMapper.this.factor);
            }
            if (num > n) {
                mb.setTarget(num + 1);
            }
            if (debug) {
                System.out.println("p(0)->" + this.points[0]);
            }
            if (debug) {
                System.out.println("p(1)->" + this.points[1]);
            }
            if (debug) {
                System.out.println("compressed");
            }
            if (usebuilder) {
                curidx = this.points.length - 1;
                n = num;
                while (curidx >= 0) {
                    mb.add(this.histogram.mapIndexToValue(curidx), n--);
                    curidx = this.points[curidx];
                }
            } else {
                int idx = curidx = this.points.length - 1;
                int it = this.histogram.mapIndexToValue(curidx);
                int nextit = this.histogram.mapIndexToValue(this.points[curidx]);
                n = num;
                while (it >= 0) {
                    if (it == nextit) {
                        curidx = this.points[curidx];
                        nextit = this.histogram.mapIndexToValue(this.points[curidx]);
                        --n;
                    }
                    if (n <= 0) {
                        throw new IllegalStateException("need more colors than expected (it=" + idx + ")");
                    }
                    mapping[it--] = n;
                }
            }
            return num;
        }

        private class Pointer {
            int cur;
            int prev;
            int cnt;
            int min;

            private Pointer() {
            }
        }
    }

    protected static class ArrayHistogram
    implements Histogram {
        private int[] histogram;

        public ArrayHistogram(int size) {
            this.histogram = new int[size];
        }

        public void add(int i) {
            int n = i;
            this.histogram[n] = this.histogram[n] + 1;
        }

        public int get(int i) {
            return this.histogram[i];
        }

        public int getSize() {
            return this.histogram.length;
        }

        public int histMax() {
            int max = 0;
            for (int i = 0; i < this.histogram.length; ++i) {
                if (this.histogram[i] <= max) continue;
                max = this.histogram[i];
            }
            return max;
        }

        public int mapIndexToValue(int i) {
            if (i >= this.histogram.length) {
                return -1;
            }
            return i;
        }

        public int mapIndexToCount(int i) {
            if (i >= this.histogram.length) {
                return -1;
            }
            return this.histogram[i];
        }
    }

    protected static class TreeHistogram
    extends BalancedTreeSupport
    implements Histogram {
        private int size;
        private int max;
        private boolean indexed;

        public TreeHistogram(int size) {
            this.size = size;
            this.root = new Node(size - 1, 0);
        }

        public void add(int i) {
            if (hdeb) {
                System.out.println("add " + i);
            }
            this.root = this.add((Node)this.root, i);
        }

        private Node add(Node n, int i) {
            if (n == null) {
                if (this.max == 0) {
                    this.max = 1;
                }
                return new Node(i);
            }
            if (hdeb) {
                System.out.println("  handle " + n.value);
            }
            if (i == n.value) {
                ++n.cnt;
                if (n.cnt > this.max) {
                    this.max = n.cnt;
                }
            } else if (i > n.value) {
                n.left = this.add((Node)n.left, i);
                n = (Node)n.balanceLeft();
            } else {
                n.right = this.add((Node)n.right, i);
                n = (Node)n.balanceRight();
            }
            return n;
        }

        public int get(int i) {
            Node n = (Node)this.root;
            while (n != null) {
                if (n.value == i) {
                    return n.cnt;
                }
                if (i > n.value) {
                    n = (Node)n.left;
                    continue;
                }
                n = (Node)n.right;
            }
            return 0;
        }

        public int getSize() {
            return this.nodecount;
        }

        public int histMax() {
            return this.max;
        }

        public int mapIndexToValue(int i) {
            this.createIndex();
            Node n = (Node)this.root;
            while (n != null) {
                if (n.index == i) {
                    return n.value;
                }
                if (i > n.index) {
                    n = (Node)n.left;
                    continue;
                }
                n = (Node)n.right;
            }
            return -1;
        }

        public int mapIndexToCount(int i) {
            this.createIndex();
            Node n = (Node)this.root;
            while (n != null) {
                if (n.index == i) {
                    return n.cnt;
                }
                if (i > n.index) {
                    n = (Node)n.left;
                    continue;
                }
                n = (Node)n.right;
            }
            return -1;
        }

        private void createIndex() {
            if (!this.indexed) {
                if (this.root != null) {
                    ((Node)this.root).createIndex(0);
                }
                this.indexed = true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Node
        extends BalancedTreeSupport.TreeNode<Node> {
            int index;
            int value;
            int cnt;

            Node(int i, int c) {
                this.value = i;
                this.cnt = c;
                if (hdeb) {
                    System.out.println("CREATE " + i);
                }
                TreeHistogram.this.indexed = false;
            }

            Node(int i) {
                this(i, 1);
            }

            int createIndex(int index) {
                if (this.right != null) {
                    index = ((Node)this.right).createIndex(index);
                }
                this.index = index++;
                if (this.left != null) {
                    index = ((Node)this.left).createIndex(index);
                }
                return index;
            }

            public String toString() {
                return "" + this.value + "(" + this.cnt + ")";
            }
        }
    }

    protected static interface Histogram {
        public void add(int var1);

        public int get(int var1);

        public int getSize();

        public int histMax();

        public int mapIndexToValue(int var1);

        public int mapIndexToCount(int var1);
    }
}

