/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelInventory;
import com.mandelsoft.mand.scan.MandelScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MandelFolderCache
extends MandelInventory {
    public static final String cachefile = ".mcache";
    private AbstractFile file;
    private long timestamp;

    public static boolean isCached(File f) {
        File c = new File(f, cachefile);
        return !c.isDirectory() && c.exists();
    }

    public MandelFolderCache(File f) throws IOException {
        if (f.isDirectory()) {
            f = new File(f, cachefile);
        }
        this.file = new FileAbstractFile(f);
        this.read();
    }

    public MandelFolderCache(AbstractFile f) throws IOException {
        this.file = f;
        this.read();
    }

    public final void read() {
        try {
            this.read(this.file);
        }
        catch (IOException io) {
            System.out.println("cannot read cache " + this.file + ": " + io);
        }
    }

    private void read(AbstractFile f) throws IOException {
        this.read(f.getInputStream(), f.toString());
        this.timestamp = f.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.file.isFile()) {
            File cachefile = new File(this.file.getFile().getPath());
            try {
                this.write(new FileOutputStream(cachefile), cachefile.toString());
            }
            finally {
                this.timestamp = cachefile.lastModified();
            }
        } else {
            throw new UnsupportedOperationException("cache update only for files");
        }
    }

    public boolean removeFile(File f) {
        if (this.file.isFile()) {
            File folder = new File(this.file.getFile().getPath()).getParentFile();
            if (!f.getParentFile().equals(folder)) {
                throw new IllegalArgumentException(f + " not in directory");
            }
            return this.remove(f.getName());
        }
        throw new UnsupportedOperationException("cache update only for files");
    }

    public MandelInventory.Entry addFile(File f) {
        if (this.file.isFile()) {
            File folder = new File(this.file.getFile().getPath()).getParentFile();
            if (!f.getParentFile().equals(folder)) {
                throw new IllegalArgumentException(f + " not in directory");
            }
            try {
                MandelData md = new MandelData(true, f, false);
                return this.add(f.getName(), md, f.lastModified());
            }
            catch (IOException ex) {
                System.out.println("ignoring " + f + ": " + ex);
                return null;
            }
        }
        throw new UnsupportedOperationException("cache update only for files");
    }

    public boolean update() throws IOException {
        if (this.file.getLastModified() != this.timestamp) {
            this.read(this.file);
            return true;
        }
        return false;
    }

    public void recreate() throws IOException {
        int cnt = 0;
        if (this.file.isFile()) {
            MandelData md;
            File folder = new File(this.file.getFile().getPath()).getParentFile();
            UncachedScanner scan = new UncachedScanner(folder);
            this.cache.clear();
            System.out.println("setting up cache data...");
            for (MandelName n : scan.getMandelNames()) {
                for (MandelHandle mandelHandle : scan.getMandelHandles(n)) {
                    try {
                        md = new MandelData(true, mandelHandle.getFile(), false);
                        this.add(mandelHandle.getFile().getName(), mandelHandle.getHeader().getType(), md.getInfo(), mandelHandle.getFile().getLastModified());
                        if (++cnt % 500 != 0) continue;
                        System.out.println("  " + cnt + " mem=" + Runtime.getRuntime().freeMemory());
                        Runtime.getRuntime().gc();
                        Runtime.getRuntime().runFinalization();
                    }
                    catch (IOException ex) {
                        System.out.println("ignoring " + mandelHandle.getFile() + ": " + ex);
                        throw ex;
                    }
                }
            }
            for (ColormapName c : scan.getColormapNames()) {
                for (ColormapHandle colormapHandle : scan.getColormapHandles(c)) {
                    try {
                        md = new MandelData(true, colormapHandle.getFile(), false);
                        this.add(colormapHandle.getFile().getName(), colormapHandle.getHeader().getType(), md.getInfo(), colormapHandle.getFile().getLastModified());
                    }
                    catch (IOException ex) {
                        System.out.println("ignoring " + colormapHandle.getFile() + ": " + ex);
                        throw ex;
                    }
                }
            }
        } else {
            throw new UnsupportedOperationException("cache update only for files");
        }
        this.write();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            boolean read = false;
            for (String arg : args) {
                if (arg.equals("-r")) {
                    read = true;
                    continue;
                }
                if (arg.equals("-w")) {
                    read = false;
                    continue;
                }
                try {
                    MandelFolderCache c = new MandelFolderCache(new File(arg));
                    if (read) {
                        for (MandelInventory.Entry e : c) {
                            System.out.println(e.getFilename() + ": " + e.getType());
                        }
                        continue;
                    }
                    c.recreate();
                }
                catch (IOException ex) {
                    System.out.println("cannot read " + arg);
                }
            }
        }
    }

    private static class UncachedScanner
    extends FolderMandelScanner {
        public UncachedScanner(File d) throws IOException {
            super(d, MandelScanner.ALL);
        }

        protected MandelFolderCache getCache() {
            return null;
        }

        protected void lock() {
        }

        protected void releaseLock() {
        }
    }
}

