/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class MandelScannerListenerSupport
implements MandelScanner {
    public static boolean debug = false;
    private List<MandelScannerListener> listenerList = new ArrayList<MandelScannerListener>();
    private int insetup = 0;
    private int inupdate = 0;
    private boolean updatePending;

    protected boolean filter(MandelHeader h) {
        return true;
    }

    public synchronized void addMandelScannerListener(MandelScannerListener l) {
        this.listenerList.add(l);
    }

    public synchronized void removeMandelScannerListener(MandelScannerListener l) {
        this.listenerList.remove(l);
    }

    public synchronized MandelScannerListener[] getMandelScannerListeners() {
        return this.listenerList.toArray(new MandelScannerListener[this.listenerList.size()]);
    }

    protected void notifyAddMandelFile(MandelHandle h) {
        if (this.insetup > 0) {
            return;
        }
        if (this.inupdate != 0) {
            this.updatePending = true;
        } else {
            for (MandelScannerListener l : this.listenerList) {
                l.addMandelFile(this, h);
            }
        }
    }

    protected void notifyRemoveMandelFile(MandelHandle h) {
        if (this.insetup > 0) {
            return;
        }
        if (this.inupdate != 0) {
            this.updatePending = true;
        } else {
            for (MandelScannerListener l : this.listenerList) {
                l.removeMandelFile(this, h);
            }
        }
    }

    protected void notifyAddColormap(ColormapHandle h) {
        if (this.insetup > 0) {
            return;
        }
        if (this.inupdate != 0) {
            this.updatePending = true;
        } else {
            for (MandelScannerListener l : this.listenerList) {
                l.addColormap(this, h);
            }
        }
    }

    protected void notifyRemoveColormap(ColormapHandle h) {
        if (this.insetup > 0) {
            return;
        }
        if (this.inupdate != 0) {
            this.updatePending = true;
        } else {
            for (MandelScannerListener l : this.listenerList) {
                l.removeColormap(this, h);
            }
        }
    }

    protected void notifyScannerChanged() {
        if (this.insetup > 0) {
            return;
        }
        if (this.inupdate != 0) {
            this.updatePending = true;
        } else {
            int cnt = 0;
            for (MandelScannerListener l : this.listenerList) {
                if (debug) {
                    System.out.println("- fire scanner changed " + this + " for " + ++cnt + " " + l);
                }
                l.scannerChanged(this);
            }
        }
    }

    protected void startUpdate() {
        this.startUpdate(false);
    }

    protected void startSetup() {
        ++this.insetup;
    }

    protected void finishSetup() {
        if (this.insetup > 0) {
            --this.insetup;
        }
    }

    protected void startUpdate(boolean force) {
        ++this.inupdate;
        if (force) {
            this.updatePending = force;
        }
    }

    protected boolean isInUpdate() {
        return this.inupdate != 0;
    }

    protected void finishUpdate() {
        if (this.inupdate == 0) {
            return;
        }
        if (--this.inupdate == 0) {
            if (debug) {
                System.out.println("update finished (" + this.updatePending + ")" + this);
            }
            if (this.updatePending) {
                this.notifyScannerChanged();
            }
            this.updatePending = false;
        }
    }

    protected MandelHandle mapOut(MandelHandle h) {
        return h;
    }

    protected ColormapHandle mapOut(ColormapHandle h) {
        return h;
    }

    protected class Listener
    implements MandelScannerListener {
        protected Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMandelFile(MandelScanner s, MandelHandle h) {
            MandelScannerListenerSupport mandelScannerListenerSupport = MandelScannerListenerSupport.this;
            synchronized (mandelScannerListenerSupport) {
                if (!MandelScannerListenerSupport.this.updatePending && MandelScannerListenerSupport.this.filter(h.getHeader())) {
                    if (debug) {
                        System.out.println("forward add to " + MandelScannerListenerSupport.this);
                    }
                    MandelScannerListenerSupport.this.notifyAddMandelFile(MandelScannerListenerSupport.this.mapOut(h));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMandelFile(MandelScanner s, MandelHandle h) {
            MandelScannerListenerSupport mandelScannerListenerSupport = MandelScannerListenerSupport.this;
            synchronized (mandelScannerListenerSupport) {
                if (!MandelScannerListenerSupport.this.updatePending && MandelScannerListenerSupport.this.filter(h.getHeader())) {
                    if (debug) {
                        System.out.println("forward rem to " + MandelScannerListenerSupport.this);
                    }
                    MandelScannerListenerSupport.this.notifyRemoveMandelFile(MandelScannerListenerSupport.this.mapOut(h));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addColormap(MandelScanner s, ColormapHandle h) {
            MandelScannerListenerSupport mandelScannerListenerSupport = MandelScannerListenerSupport.this;
            synchronized (mandelScannerListenerSupport) {
                if (!MandelScannerListenerSupport.this.updatePending && MandelScannerListenerSupport.this.filter(h.getHeader())) {
                    MandelScannerListenerSupport.this.notifyAddColormap(MandelScannerListenerSupport.this.mapOut(h));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeColormap(MandelScanner s, ColormapHandle h) {
            MandelScannerListenerSupport mandelScannerListenerSupport = MandelScannerListenerSupport.this;
            synchronized (mandelScannerListenerSupport) {
                if (!MandelScannerListenerSupport.this.updatePending && MandelScannerListenerSupport.this.filter(h.getHeader()) && !MandelScannerListenerSupport.this.hasColormap((ColormapName)h.getName())) {
                    MandelScannerListenerSupport.this.notifyRemoveColormap(MandelScannerListenerSupport.this.mapOut(h));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scannerChanged(MandelScanner s) {
            MandelScannerListenerSupport mandelScannerListenerSupport = MandelScannerListenerSupport.this;
            synchronized (mandelScannerListenerSupport) {
                if (debug) {
                    System.out.println("forward all to " + MandelScannerListenerSupport.this);
                }
                MandelScannerListenerSupport.this.notifyScannerChanged();
            }
        }
    }
}

