/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.CachedColormapHandle;
import com.mandelsoft.mand.scan.CachedMandelHandle;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListenerSupport;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.util.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MandelScannerSupport
extends MandelScannerListenerSupport {
    public static boolean debug = false;
    public static final MandelHeader colmapHeader = new MandelHeader(4);
    private MandelScanner.Filter filter;
    private boolean colmaps = true;

    protected MandelScannerSupport() {
    }

    protected MandelScannerSupport(MandelScanner.Filter filter) {
        this.filter = filter;
        this.colmaps = this.filter(colmapHeader);
    }

    @Override
    public synchronized void setFilter(MandelScanner.Filter filter) {
        this.filter = filter;
        this.colmaps = this.filter(colmapHeader);
        this.rescan(false);
    }

    @Override
    public synchronized MandelScanner.Filter getFilter() {
        return this.filter;
    }

    @Override
    protected boolean filter(MandelHeader h) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.filter(h);
    }

    protected boolean isFiltered() {
        return this.filter != null;
    }

    protected boolean providesColormaps() {
        return this.colmaps;
    }

    protected abstract Set<MandelName> _getMandelNames();

    protected abstract Set<MandelHandle> _getMandelHandles(MandelName var1);

    protected abstract Set<ColormapName> _getColormapNames();

    protected abstract Set<ColormapHandle> _getColormapHandles(ColormapName var1);

    @Override
    public abstract void rescan(boolean var1);

    @Override
    public Set<MandelName> getMandelNames() {
        return new HashSet<MandelName>(this._getMandelNames());
    }

    @Override
    public Set<MandelHandle> getMandelHandles(MandelName name) {
        return new HashSet<MandelHandle>(this._getMandelHandles(name));
    }

    @Override
    public Set<ColormapName> getColormapNames() {
        return new HashSet<ColormapName>(this._getColormapNames());
    }

    @Override
    public Set<ColormapHandle> getColormapHandles(ColormapName name) {
        return new HashSet<ColormapHandle>(this._getColormapHandles(name));
    }

    @Override
    public synchronized Set<ElementHandle<?>> getAllHandles() {
        HashSet set = new HashSet();
        for (MandelName mandelName : this.getMandelNames()) {
            set.addAll(this.getMandelHandles(mandelName));
        }
        for (ColormapName colormapName : this.getColormapNames()) {
            set.addAll(this.getColormapHandles(colormapName));
        }
        return set;
    }

    @Override
    public synchronized Set<MandelHandle> getMandelHandles() {
        HashSet<MandelHandle> set = new HashSet<MandelHandle>();
        for (MandelName n : this.getMandelNames()) {
            set.addAll(this.getMandelHandles(n));
        }
        return set;
    }

    @Override
    public synchronized Set<QualifiedMandelName> getQualifiedMandelNames() {
        HashSet<QualifiedMandelName> set = new HashSet<QualifiedMandelName>();
        for (MandelName n : this.getMandelNames()) {
            for (MandelHandle h : this.getMandelHandles(n)) {
                set.add((QualifiedMandelName)h.getName());
            }
        }
        return set;
    }

    @Override
    public synchronized MandelHandle getMandelInfo(MandelName name) {
        CachedMandelHandle best = null;
        for (MandelHandle h : this.getMandelHandles(name)) {
            if (!h.getHeader().hasInfo() || h != MandUtils.better(best, h)) continue;
            try {
                best = new CachedMandelHandle(h).assertInfo();
            }
            catch (IOException ex) {
                System.out.println("cannot read " + h.getFile() + ": " + ex);
            }
        }
        return best;
    }

    @Override
    public synchronized MandelHandle getMandelData(MandelName name) {
        CachedMandelHandle best = null;
        for (MandelHandle h : this.getMandelHandles(name)) {
            if (h != MandUtils.better(best, h)) continue;
            try {
                best = new CachedMandelHandle(h).assertData();
            }
            catch (IOException ex) {
                System.out.println("cannot read " + h.getFile() + ": " + ex);
            }
        }
        return best;
    }

    @Override
    public Set<QualifiedMandelName> getQualifiedMandelNames(MandelName name) {
        HashSet<QualifiedMandelName> set = new HashSet<QualifiedMandelName>();
        for (MandelHandle h : this._getMandelHandles(name)) {
            set.add((QualifiedMandelName)h.getName());
        }
        return set;
    }

    @Override
    public Set<MandelHandle> getMandelHandles(QualifiedMandelName name) {
        HashSet<MandelHandle> set = new HashSet<MandelHandle>();
        for (MandelHandle h : this._getMandelHandles(name.getMandelName())) {
            if (!Utils.equals(h.getQualifier(), name.getQualifier())) continue;
            set.add(h);
        }
        return set;
    }

    @Override
    public synchronized MandelHandle getMandelHandle(QualifiedMandelName name) {
        MandelHandle best = null;
        for (MandelHandle h : this.getMandelHandles(name)) {
            if (!h.getHeader().hasInfo()) continue;
            best = MandUtils.better(best, h);
        }
        return best;
    }

    @Override
    public synchronized MandelHandle getMandelInfo(QualifiedMandelName name) {
        Set<MandelHandle> set = this.getMandelHandles(name);
        while (!set.isEmpty()) {
            MandelHandle best = null;
            for (MandelHandle h : set) {
                if (!h.getHeader().hasInfo()) continue;
                best = MandUtils.better(best, h);
            }
            if (best == null) break;
            try {
                return new CachedMandelHandle(best).assertInfo();
            }
            catch (IOException ex) {
                set.remove(best);
            }
        }
        return null;
    }

    @Override
    public synchronized MandelHandle getMandelData(QualifiedMandelName name) {
        Set<MandelHandle> set = this.getMandelHandles(name);
        while (!set.isEmpty()) {
            MandelHandle best = null;
            for (MandelHandle h : set) {
                best = MandUtils.better(best, h);
            }
            if (best == null) break;
            try {
                return new CachedMandelHandle(best).assertData();
            }
            catch (IOException ex) {
                set.remove(best);
            }
        }
        return null;
    }

    @Override
    public ColormapHandle getColormap(ColormapName name) {
        Set<ColormapHandle> set = this.getColormapHandles(name);
        if (!set.isEmpty()) {
            for (ColormapHandle h : set) {
                try {
                    return new CachedColormapHandle(h).assertData();
                }
                catch (IOException ex) {
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasColormap(ColormapName name) {
        return !this._getColormapHandles(name).isEmpty();
    }
}

