/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;

public class MandelAreaCreationDialog
extends MandelAreaViewDialog {
    private Set<MandelAreaListener> listeners = new HashSet<MandelAreaListener>();

    public MandelAreaCreationDialog(MandelWindowAccess owner, String title, String file, MandelName name, MandelInfo info) {
        super(owner, title, new QualifiedMandelName(name), info, true, false);
        this.setFilename(file);
    }

    public MandelAreaCreationDialog(MandelWindowAccess owner, String title) {
        super(owner, title, true, false);
    }

    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new CreationView(name, (MandelInfo)info);
    }

    public void setFilename(String file) {
        ((CreationView)this.getView()).setFilename(file);
    }

    public void setFilename(String file, boolean modifiable) {
        ((CreationView)this.getView()).setFilename(file, modifiable);
    }

    public void setAutoMode(boolean b) {
        ((CreationView)this.getView()).setAutoMode(b);
    }

    public MandelWindowAccess getMandelFrame() {
        return this.getMandelWindowAccess();
    }

    public void addCreationListener(MandelAreaListener l) {
        this.listeners.add(l);
    }

    public void removeCreationListener(MandelAreaListener l) {
        this.listeners.remove(l);
    }

    protected void fireCreationEvent(MandelName name, MandelInfo info, BufferedComponent.VisibleRect r) {
        this.fireMandelAreaEvent(new MandelAreaEvent(this, name, info, r));
    }

    protected void fireDeletionEvent(MandelName name, File file) {
        this.fireMandelAreaEvent(new MandelAreaEvent(this, name, file));
    }

    protected void fireMandelAreaEvent(MandelAreaEvent e) {
        for (MandelAreaListener l : this.listeners) {
            l.areaActionPerformed(e);
        }
    }

    public static interface MandelAreaListener {
        public void areaActionPerformed(MandelAreaEvent var1);
    }

    public static class MandelAreaEvent
    extends EventObject {
        public static final int MA_CREATED = 1;
        public static final int MA_DELETED = 2;
        public static final int MA_UPDATE = 3;
        private int id;
        private MandelInfo info;
        private MandelName name;
        private BufferedComponent.VisibleRect rect;
        private File file;

        public MandelAreaEvent(Component c, MandelName name, MandelInfo info, BufferedComponent.VisibleRect r) {
            this(c, 1);
            this.name = name;
            this.info = info;
            this.rect = r;
        }

        public MandelAreaEvent(Component c, MandelName name, File file) {
            this(c, 2);
            this.name = name;
            this.file = file;
        }

        public MandelAreaEvent(Component c, int id) {
            super(c);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public MandelInfo getInfo() {
            return this.info;
        }

        public MandelName getName() {
            return this.name;
        }

        public BufferedComponent.VisibleRect getRect() {
            return this.rect;
        }

        public File getFile() {
            return this.file;
        }

        public Object getOwner() {
            return this.rect.getOwner();
        }
    }

    protected class CreationView
    extends MandelAreaViewDialog.MandelAreaView {
        protected JTextField filename;
        protected boolean automode;

        public CreationView(QualifiedMandelName name, MandelInfo info) {
            super((MandelAreaViewDialog)MandelAreaCreationDialog.this, name, info, true, false);
            this.automode = true;
        }

        public void setFilename(String n) {
            this.setFilename(n, true);
        }

        public void setAutoMode(boolean b) {
            this.automode = b;
        }

        public void setFilename(String n, boolean modifiable) {
            this.filename.setText(n);
            this.filename.setEditable(modifiable);
        }

        public String getFilename() {
            return this.filename.getText();
        }

        protected void setupFields() {
            super.setupFields();
            int row = this.getMaxGridRow() + 1;
            this.setMaxGridRow(row);
            this.filename = new JTextField();
            this.add((Component)this.filename, this.GBC(0, row).setSpanW(this.getMaxGridCol() + 1).setFill(2).setInsets(10, 0, 0, 0).setWeight(200.0, 0.0));
        }

        protected void setupButtons() {
            super.setupButtons();
            this.createButton("AdjustX", "Adjust area width to preserve image propotion.", new AdjustXAction());
            this.createButton("AdjustY", "Adjust area height to preserve image propotion.", new AdjustYAction());
            this.createButton("Adjust Width", "Adjust image width to preserve image propotion.", new AdjustWidthAction());
            this.createButton("Adjust Height", "Adjust image height to preserve image propotion.", new AdjustHeightAction());
            this.createButton("Normalize", "Normalize coordinates preserving visible area.", new NormAction());
            this.createButton("Round", "Round image area specifical to useful precision.", new RoundAction());
            this.newButtonPanel();
            this.createButton("Save", null, new SaveAction());
            this.createButton("Load", null, new LoadAction());
            this.createButton("Delete", null, new DeleteAction());
        }

        protected BufferedComponent.VisibleRect getSelectedRect() {
            return null;
        }

        private class DeleteAction
        implements ActionListener {
            private DeleteAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(CreationView.this.getFilename())) {
                    return;
                }
                File f = new File(CreationView.this.getFilename());
                MandelName name = MandelName.create(f);
                if (name == null) {
                    MandelAreaCreationDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (!f.exists()) {
                    MandelAreaCreationDialog.this.mandelError("File does not exist.");
                    return;
                }
                if (!MandelAreaCreationDialog.this.deleteFileDialog(f)) {
                    return;
                }
                try {
                    MandelFolder.Util.delete(f);
                }
                catch (IOException ex) {
                    MandelAreaCreationDialog.this.mandelError("Delete Error: " + ex);
                }
                if (f.exists()) {
                    MandelAreaCreationDialog.this.mandelError("Cannot delete " + f + ".");
                    return;
                }
                MandelAreaCreationDialog.this.fireDeletionEvent(name, f);
                System.out.println("are editable " + CreationView.this.filename.isEditable());
                if (!CreationView.this.filename.isEditable()) {
                    MandelAreaCreationDialog.this.getDialog().setVisible(false);
                }
            }
        }

        private class LoadAction
        implements ActionListener {
            private LoadAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(CreationView.this.getFilename())) {
                    return;
                }
                File file = new File(CreationView.this.getFilename());
                MandelFileName mfn = MandelFileName.create(file.getName());
                if (mfn == null) {
                    MandelAreaCreationDialog.this.mandelError(CreationView.this.getFilename() + " is no valid mandel area name.");
                    return;
                }
                try {
                    AbstractFile f = MandelAreaCreationDialog.this.getMandelWindowAccess().getEnvironment().createMandelFile(CreationView.this.getFilename());
                    MandelData tmp = new MandelData(f);
                    if (!tmp.getHeader().isInfo()) {
                        MandelAreaCreationDialog.this.mandelError("this is not a mandel parameter file.");
                        return;
                    }
                    CreationView.this.getInfo().copyFrom(tmp.getInfo());
                    CreationView.this.updateFields();
                }
                catch (IOException ex) {
                    MandelAreaCreationDialog.this.mandelError("Cannot read mandel info file", ex);
                }
            }
        }

        private class SaveAction
        implements ActionListener {
            private SaveAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(CreationView.this.getFilename())) {
                    return;
                }
                MandelInfo info = CreationView.this.getInfo();
                info.setSite(MandelAreaCreationDialog.this.getEnvironment().getProperty("sitename"));
                info.setCreator(MandelAreaCreationDialog.this.getEnvironment().getProperty("username"));
                info.setCreationTime(System.currentTimeMillis());
                MandelData md = new MandelData(info);
                File f = new File(CreationView.this.getFilename());
                MandelFileName name = MandelFileName.create(f);
                if (name == null) {
                    MandelAreaCreationDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (f.exists() && !MandelAreaCreationDialog.this.overwriteFileDialog(f)) {
                    return;
                }
                MandelAreaCreationDialog.this.getMandelWindowAccess().getEnvironment().autoRescan();
                if (MandelAreaCreationDialog.this.getMandelWindowAccess().getEnvironment().getImageDataScanner().getMandelHandle(name.getQualifiedName()) != null) {
                    MandelAreaCreationDialog.this.mandelError("Image for " + name + " already exists.");
                    return;
                }
                try {
                    md.write(f);
                    MandelAreaCreationDialog.this.fireCreationEvent(name.getName(), md.getInfo(), CreationView.this.getSelectedRect());
                    MandelAreaCreationDialog.this.getDialog().setVisible(false);
                }
                catch (IOException ex) {
                    MandelAreaCreationDialog.this.mandelError("Cannot write mandel info file", ex);
                }
            }
        }

        private class RoundAction
        implements ActionListener {
            private RoundAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.round(info);
                CreationView.this.setInfo(info);
            }
        }

        private class NormAction
        implements ActionListener {
            private NormAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.normalize(info);
                CreationView.this.setInfo(info);
            }
        }

        private class AdjustHeightAction
        implements ActionListener {
            private AdjustHeightAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.adjustHeight(info);
                CreationView.this.setInfo(info);
            }
        }

        private class AdjustWidthAction
        implements ActionListener {
            private AdjustWidthAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.adjustWidth(info);
                CreationView.this.setInfo(info);
            }
        }

        private class AdjustYAction
        implements ActionListener {
            private AdjustYAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.adjustDY(info);
                CreationView.this.setInfo(info);
            }
        }

        private class AdjustXAction
        implements ActionListener {
            private AdjustXAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelInfo info = new MandelInfo(CreationView.this.getInfo());
                MandUtils.adjustDX(info);
                CreationView.this.setInfo(info);
            }
        }
    }
}

