/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.AltSpec;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelSpecDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ModTimes;
import com.mandelsoft.mand.tool.TagSpec;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.swing.DataField;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.NumberField;
import com.mandelsoft.swing.TextField;
import com.mandelsoft.swing.Utils;
import com.mandelsoft.swing.WindowControlAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MandelAreaViewDialog
extends MandelDialog {
    private MandelAreaView view;

    public static boolean isReadonly(MandelWindowAccess owner, AbstractFile f, QualifiedMandelName name) {
        return f != null && !f.isFile() || name != null && owner.getEnvironment().isReadonly(name.getLabel()) || owner.getEnvironment().isReadonly();
    }

    public static String getInfoString(ToolEnvironment env, QualifiedMandelName qname) {
        if (qname == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (env.getFavorites() != null && MandelAreaViewDialog.contains(env.getFavorites().getRoot(), qname.getMandelName())) {
            sb.append("Favorite");
        }
        if (env.getTodos() != null && MandelAreaViewDialog.contains(env.getTodos().getRoot(), qname.getMandelName())) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("Todo");
        }
        if (env.getAreas() != null && MandelAreaViewDialog.contains(env.getAreas(), qname.getMandelName())) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("Key area");
        }
        return sb.toString();
    }

    private static boolean contains(MandelList list, MandelName name) {
        for (QualifiedMandelName n : list) {
            if (!name.equals(n.getMandelName())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(MandelListFolder folder, MandelName name) {
        for (QualifiedMandelName n : folder.allentries()) {
            if (!name.equals(n.getMandelName())) continue;
            return true;
        }
        return false;
    }

    public MandelAreaViewDialog(MandelWindowAccess owner, String title) {
        super(owner, title);
    }

    public MandelAreaViewDialog(MandelWindowAccess owner, String title, QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        super(owner, title);
        this.setup(name, info, change, readonly);
        this.setVisible(true);
    }

    public MandelAreaViewDialog(MandelWindowAccess owner, String title, boolean change, boolean readonly) {
        super(owner, title);
        this.setup(null, new MandelInfo(), change, readonly);
    }

    protected void setup(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        this.view = this.createView(name, info, change, readonly);
        this.add(this.view);
        this.pack();
        this.setResizable(false);
    }

    protected MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new MandelAreaView(name, (MandelInfo)info, change, readonly);
    }

    protected MandelAreaView getView() {
        return this.view;
    }

    protected JDialog getDialog() {
        return this;
    }

    public void setInfo(String name, MandelInfo info) {
        this.getView().setInfo(name, info);
    }

    public void setData(String name, MandelData data) {
        this.getView().setData(name, data);
    }

    public MandelInfo getInfo() {
        return this.getView().getInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BeanAccess<T>
    extends ValueAccess<T> {
        private String prop;
        private Object bean;
        private Method setter;
        private Method getter;
        private Class type;

        public BeanAccess(Object bean, String prop) {
            this.bean = bean;
            this.prop = prop;
            String mname = "get" + prop;
            for (Method m : bean.getClass().getMethods()) {
                Class r;
                Class<?>[] params;
                if (!m.getName().equals(mname) || (params = m.getParameterTypes()) != null && params.length != 0 || (r = this.mapType(m.getReturnType())) == null || !Number.class.isAssignableFrom(r) && !String.class.isAssignableFrom(r)) continue;
                this.getter = m;
                this.type = r;
            }
            mname = "set" + prop;
            if (this.type != null) {
                try {
                    Method m = bean.getClass().getMethod(mname, this.type);
                    this.setter = this.checkSetter(m);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.setter == null) {
                for (Method m : bean.getClass().getMethods()) {
                    if (!m.getName().equals(mname)) continue;
                    this.setter = this.checkSetter(m);
                    if (this.setter != null) break;
                }
            }
        }

        public String getProperty() {
            return this.prop;
        }

        protected Method checkSetter(Method m) {
            Class<?>[] params = m.getParameterTypes();
            if (params != null && params.length == 1) {
                if (params[0] == this.type) {
                    return m;
                }
                Class t = this.mapType(params[0]);
                if (Number.class.isAssignableFrom(t)) {
                    if (this.type == null) {
                        this.type = t;
                    }
                    return m;
                }
            }
            return null;
        }

        private Class mapType(Class t) {
            if (t == Double.TYPE) {
                t = Double.class;
            } else if (t == Float.TYPE) {
                t = Float.class;
            } else if (t == Long.TYPE) {
                t = Long.class;
            } else if (t == Integer.TYPE) {
                t = Integer.class;
            } else if (t == Short.TYPE) {
                t = Short.class;
            } else if (t == Byte.TYPE) {
                t = Byte.class;
            }
            return t;
        }

        public Class getType() {
            return this.type;
        }

        public boolean hasGetter() {
            return this.getter != null;
        }

        public boolean hasSetter() {
            return this.setter != null;
        }

        @Override
        public void setValue(T n) {
            System.out.println("setting " + this.prop + " to " + n);
            if (this.setter == null) {
                throw new IllegalArgumentException("no setter for property " + this.prop);
            }
            try {
                this.setter.invoke(this.bean, Utils.convertValueToValueClass(n, this.type));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("cannot access property " + this.setter);
            }
        }

        @Override
        public T getValue() {
            if (this.getter == null) {
                throw new IllegalArgumentException("no getter for property " + this.prop);
            }
            try {
                return (T)this.getter.invoke(this.bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("cannot access property " + this.setter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ValueAccess<T>
    implements ActionListener,
    PropertyChangeListener {
        protected ValueAccess() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataField f = (DataField)e.getSource();
            this.setValue(f.getDataValue());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            System.out.println("CHANGE " + propertyName + "=" + e.getOldValue() + "->" + e.getNewValue());
            this.setValue(e.getNewValue());
        }

        public abstract void setValue(T var1);

        public abstract T getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MandelAreaView
    extends GBCPanel {
        protected QualifiedMandelName qname;
        private boolean inupdate;
        private MandelInfo info;
        protected MandelData data;
        private boolean change;
        protected boolean readonlyMode;
        private JLabel label;
        private int[] row;
        private int col;
        private int maxcol = 0;
        private PropertyChangeListener updateListener;
        protected NumberField limitfield;
        protected JTextField infofield;
        private Map<DataField<?>, ValueAccess<?>> fields = new HashMap();
        protected JPanel buttons;
        private ModTimesAction modtimes;
        private JButton modtimes_button;
        private TagsAction tags;
        private JButton tags_button;
        private AltSpecAction altspec;

        public MandelAreaView(QualifiedMandelName name, MandelInfo info, boolean change, boolean readonly) {
            this.change = change && !readonly;
            this.readonlyMode = readonly;
            this.info = info;
            this.updateListener = new UpdateListener();
            this.setup();
            this.setName(name);
        }

        public MandelAreaView(QualifiedMandelName name, MandelData data, boolean change, boolean readonly) {
            this.change = change && !readonly;
            this.readonlyMode = readonly;
            this.qname = name;
            this.data = data;
            this.info = data.getInfo();
            this.updateListener = new UpdateListener();
            this.setup();
            this.setName(name);
        }

        public MandelAreaView(boolean change) {
            this(null, new MandelInfo(), change, !change);
        }

        public void setName(QualifiedMandelName name) {
            if (name == null) {
                return;
            }
            this.qname = name;
            String text = name.isRoot() ? "Root Area" : "Area " + name.getName();
            this.setName(text);
            if (this.altspec != null) {
                this.altspec.setName(text);
            }
            if (this.modtimes != null) {
                this.modtimes.setName(text);
            }
            if (this.tags != null) {
                this.tags.setName(text);
            }
            this.label.setText(text);
        }

        public void setInfo(String name, MandelInfo info) {
            this.data = null;
            this.setName(name);
            this._setInfo(info);
        }

        protected void _setInfo(MandelInfo info) {
            this.info.setInfo(info);
            this.updateFields();
        }

        public void setInfo(MandelInfo info) {
            this.data = null;
            this._setInfo(info);
        }

        public void setData(String name, MandelData data) {
            this.data = data;
            this.setName(name);
            this._setInfo(data.getInfo());
        }

        public void setData(MandelData data) {
            this.data = data;
            this._setInfo(data.getInfo());
        }

        public MandelInfo getInfo() {
            return this.info;
        }

        public MandelData getData() {
            return this.data;
        }

        @Override
        protected void adjustBorderArea(Rectangle rect) {
            rect.setRect(rect.getX() * 2.0, rect.getY() + 1.0, rect.getWidth() * 2.0, rect.getHeight());
        }

        protected void setup() {
            this.col = 0;
            this.row = new int[this.col + 1];
            this.row[this.col] = 1;
            this.setupFields();
            this.label = new JLabel(this.getName());
            this.add((Component)this.label, new GBC(0, 0, (this.maxcol + 1) * 2, 1).setLayout(2, 10).setBottomInset(10));
            this.label.setHorizontalAlignment(0);
            this.label.setFont(this.label.getFont().deriveFont(1, this.label.getFont().getSize() + 2));
            this.setupButtonPanel();
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        protected void setCol(int col) {
            this.col = col;
            if (col > this.maxcol) {
                int i;
                int[] old = this.row;
                this.row = new int[col + 1];
                for (i = 0; i < old.length; ++i) {
                    this.row[i] = old[i];
                }
                while (i <= col) {
                    this.row[i] = 1;
                    ++i;
                }
                this.maxcol = col;
            }
        }

        protected int getCol() {
            return this.col;
        }

        protected int getRow(int col) {
            if (col > this.maxcol) {
                return 1;
            }
            return this.row[col] - 1;
        }

        protected int getRow() {
            return this.getRow(this.col);
        }

        protected void skipRows(int n) {
            while (n > 0) {
                --n;
                JLabel d1 = new JLabel("");
                JLabel d2 = new JLabel("");
                this.addField(d1, d2);
            }
        }

        protected int getGridRowFieldCol(int col) {
            if (col > this.maxcol) {
                return 1;
            }
            return this.row[col];
        }

        protected int getGridRowForGridCol(int col) {
            if (col / 2 > this.maxcol) {
                return 1;
            }
            return this.row[col / 2];
        }

        protected int getMaxGridRow() {
            int max = 0;
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i] <= max) continue;
                max = this.row[i];
            }
            return max;
        }

        protected int getMaxGridCol() {
            return this.row.length * 2 + 1;
        }

        protected void setMaxGridRow(int max) {
            for (int i = 0; i < this.row.length; ++i) {
                if (this.row[i] >= max) continue;
                this.row[i] = max;
            }
        }

        protected void addSeparator() {
            JSeparator sep = new JSeparator();
            sep.setName("sep");
            int n = this.col;
            int n2 = this.row[n];
            this.row[n] = n2 + 1;
            this.add((Component)sep, new GBC(this.col * 2, n2, 2, 1).setWeight(100.0, 0.0).setLayout(1, 10).setInsets(10, 0, 10, 0));
        }

        protected JTextField createField(String name, String prop) {
            return this.createField(name, prop, this.change);
        }

        protected JTextField createField(String name, String prop, boolean change) {
            return this.createField(name, prop, change, null);
        }

        protected JTextField createField(String name, String prop, boolean change, DataField field) {
            BeanAccess<String> access = new BeanAccess<String>(this.info, prop);
            Class type = access.getType();
            if (!access.hasGetter()) {
                throw new IllegalArgumentException("no getter found for " + prop + " in " + this.info.getClass());
            }
            if (String.class == type) {
                field = this.createTextField((TextField)field, access);
            } else {
                if (!Number.class.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("illegal type for " + prop + " in " + this.info.getClass());
                }
                field = this.createNumberField((NumberField)field, access);
            }
            return this.setupField(field, name, change, access);
        }

        private DataField<String> createTextField(TextField field, ValueAccess<String> access) {
            if (field == null) {
                field = new TextField(access.getValue());
            } else {
                field.setDataValue(access.getValue());
            }
            return field;
        }

        private DataField<Number> createNumberField(NumberField field, ValueAccess<Number> access) {
            if (field == null) {
                field = new NumberField(access.getValue());
            } else {
                field.setDataValue(access.getValue());
            }
            field.setEnforceCorrectValue(true);
            return field;
        }

        private <T> JTextField setupField(DataField<T> dfield, String name, boolean change, ValueAccess<T> up) {
            JTextField field = (JTextField)((Object)dfield);
            field.setEditable(change);
            field.setHorizontalAlignment(11);
            field.setColumns(15);
            if (up != null) {
                field.addActionListener(up);
            }
            field.addPropertyChangeListener("value", this.updateListener);
            if (!change) {
                field.setBorder(null);
            }
            this.setupField(field, name);
            if (up != null) {
                this.fields.put(dfield, up);
            }
            return field;
        }

        protected JTextField createInfoField(String name, String value) {
            return this.createInfoField(name, value, 15);
        }

        protected JTextField createInfoField(String name, String value, int len) {
            JTextField field = new JTextField(value);
            field.setEditable(this.change);
            field.setColumns(len);
            field.setBorder(null);
            field.setHorizontalAlignment(4);
            this.setupField(field, name);
            return field;
        }

        protected void addField(JLabel label, JComponent field) {
            label.setLabelFor(field);
            label.setHorizontalAlignment(2);
            this.add((Component)label, new GBC(this.col * 2, this.row[this.col]).setWeight(0.0, 0.0).setAnchor(17));
            int n = this.col;
            int n2 = this.row[n];
            this.row[n] = n2 + 1;
            this.add((Component)field, new GBC(this.col * 2 + 1, n2).setWeight(100.0, 10.0).setLeftInset(10));
        }

        protected void setupField(JTextField field, String name) {
            this.addField(new JLabel(name), field);
        }

        protected void updateFields() {
            this.setAltSpec();
            this.setModTimes();
            this.setTags();
            for (DataField<?> f : this.fields.keySet()) {
                ValueAccess<?> acc2 = this.fields.get(f);
                f.setDataValue(acc2.getValue());
            }
        }

        protected void newButtonPanel() {
            int row = this.getMaxGridRow() + 1;
            this.setMaxGridRow(row);
            this.buttons = new JPanel();
            this.add((Component)this.buttons, this.GBC(0, row).setSpanW(this.getMaxGridCol() + 1));
        }

        protected void setupButtonPanel() {
            this.newButtonPanel();
            this.setupButtons();
        }

        protected JButton createButton(String name, String tip, ActionListener l) {
            JButton b = new JButton(name);
            if (tip != null) {
                b.setToolTipText(tip);
            }
            b.addActionListener(l);
            this.buttons.add(b);
            return b;
        }

        protected void setupButtons() {
            this.modtimes = new ModTimesAction();
            JButton b = this.modtimes_button = new JButton(this.modtimes);
            b.setToolTipText("Show modification times");
            this.buttons.add(b);
            this.altspec = new AltSpecAction();
            b = new JButton(this.altspec);
            b.setToolTipText("Show alternate coordinate format");
            this.buttons.add(b);
            this.tags = new TagsAction();
            b = this.tags_button = new JButton(this.tags);
            b.setToolTipText("Show area tags");
            this.buttons.add(b);
            this.modtimes_button.setVisible(this.data != null);
        }

        private void setModTimes() {
            if (this.modtimes != null) {
                if (this.getData() != null) {
                    this.modtimes.setData(this.getData());
                    this.modtimes_button.setVisible(true);
                } else {
                    this.modtimes.setEnabled(true);
                    this.modtimes_button.setVisible(false);
                }
            }
        }

        private void setTags() {
            if (this.tags != null) {
                if (this.getInfo() != null) {
                    this.tags.setInfo(this.getInfo());
                    this.tags_button.setVisible(true);
                } else {
                    this.tags.setEnabled(true);
                    this.tags_button.setVisible(false);
                }
            }
        }

        private void setAltSpec() {
            if (this.altspec != null) {
                this.altspec.setInfo(this.getInfo());
            }
        }

        protected void setupFields() {
            this.createField("area center X", "XM");
            this.createField("area center Y", "YM");
            this.createField("dimension X", "DX");
            this.createField("dimension Y", "DY");
            this.limitfield = (NumberField)this.createField("iteration limit", "LimitIt");
            this.createField("image width", "RX");
            this.createField("image height", "RY");
            this.createField("location hint", "Location").setEditable(!this.readonlyMode);
            if (this.qname != null) {
                this.infofield = this.createInfoField("info", this.getInfoString());
            } else {
                this.skipRows(1);
            }
            this.addBorder(0, 7, 1, 2);
            this.addBorder(0, 5, 1, 2);
            this.addBorder(0, 0, 1, 5);
        }

        protected String getInfoString() {
            return MandelAreaViewDialog.getInfoString(MandelAreaViewDialog.this.getEnvironment(), this.qname);
        }

        protected void updateSlave() {
            if (this.qname != null && this.infofield != null) {
                this.infofield.setText(this.getInfoString());
            }
        }

        class UpdateListener
        implements PropertyChangeListener {
            UpdateListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                ValueAccess acc2 = (ValueAccess)MandelAreaView.this.fields.get((DataField)evt.getSource());
                if (acc2 != null) {
                    acc2.propertyChange(evt);
                }
                if (!MandelAreaView.this.inupdate) {
                    MandelAreaView.this.setAltSpec();
                }
                MandelAreaView.this.updateSlave();
            }
        }

        private class AltSpecAction
        extends SubSpecAction {
            public AltSpecAction() {
                super("Alt. Spec");
            }

            protected MandelSpecDialog createDialog(Window owner, String name, boolean change) {
                return new AltSpec(owner, name, change);
            }
        }

        private class TagsAction
        extends SubSpecAction {
            public TagsAction() {
                super("Tags");
            }

            protected MandelSpecDialog createDialog(Window owner, String name, boolean change) {
                return new TagSpec(owner, name, !MandelAreaView.this.readonlyMode);
            }
        }

        private class ModTimesAction
        extends SubSpecAction {
            public ModTimesAction() {
                super("Modification Times");
            }

            protected MandelSpecDialog createDialog(Window owner, String name, boolean change) {
                ModTimes spec = new ModTimes(owner, name);
                spec.setData(MandelAreaView.this.getData());
                return spec;
            }
        }

        private abstract class SubSpecAction
        extends WindowControlAction {
            private MandelSpecDialog spec;

            public SubSpecAction(String label) {
                super(null, label);
            }

            public void setInfo(MandelInfo info) {
                if (this.spec != null) {
                    this.spec.setInfo(info);
                }
            }

            public void setData(MandelData data) {
                if (this.spec != null) {
                    this.spec.setData(data);
                }
            }

            public void setName(String name) {
                if (this.spec != null) {
                    this.spec.setName(name);
                }
            }

            protected Window createWindow(Window owner) {
                if (owner == null) {
                    Container c = MandelAreaView.this;
                    while (c.getParent() != null && !(c instanceof Window)) {
                        c = c.getParent();
                    }
                    owner = (Window)c;
                }
                this.spec = this.createDialog(owner, MandelAreaView.this.getName(), MandelAreaView.this.change);
                this.setInfo(MandelAreaView.this.getInfo());
                this.spec.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        MandelSpecDialog s = (MandelSpecDialog)e.getSource();
                        MandelAreaView.this.inupdate = true;
                        s.updateInfo(MandelAreaView.this.getInfo());
                        MandelAreaView.this.updateFields();
                        MandelAreaView.this.inupdate = false;
                    }
                });
                return this.spec;
            }

            protected abstract MandelSpecDialog createDialog(Window var1, String var2, boolean var3);
        }
    }
}

