/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class MandelImageAreaDialog
extends MandelAreaViewDialog {
    public MandelImageAreaDialog(MandelWindowAccess owner, String title, String file, QualifiedMandelName name, MandelInfo info, boolean readonly) {
        super(owner, title, name, info, false, readonly);
        ((View)this.getView()).setFilename(file);
    }

    public MandelImageAreaDialog(MandelWindowAccess owner, String title, QualifiedMandelName name, MandelData data) {
        super(owner, title);
        AbstractFile f = data.getFile();
        if (f != null) {
            System.out.println("data file " + f + " (" + f.isFile() + ")");
        }
        this.setup(name, data, false, MandelImageAreaDialog.isReadonly(owner, f, name));
        if (f != null) {
            ((View)this.getView()).setFilename(f.toString());
        }
    }

    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new View(name, (MandelData)info, readonly);
    }

    public void setFilename(String file) {
        ((View)this.getView()).setFilename(file);
    }

    static String formatTime(long t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf("%d:%02d:%02d", t / 3600L, t / 60L % 60L, t % 60L);
        return sw.toString();
    }

    protected class View
    extends MandelAreaViewDialog.MandelAreaView {
        protected JTextField filename;
        protected JButton save;

        public View(QualifiedMandelName name, MandelInfo info, boolean readonly) {
            super(name, info, false, readonly);
        }

        public View(QualifiedMandelName name, MandelData data, boolean readonly) {
            super(name, data, false, readonly);
        }

        public void setFilename(String n) {
            this.filename.setText(n);
        }

        protected void setupFields() {
            int row;
            MandelHeader h = null;
            MandelHeader oh = null;
            if (this.data != null) {
                h = this.data.getHeader();
                oh = this.data.getOrigHeader();
            }
            super.setupFields();
            if (this.data != null) {
                row = this.getRow();
                this.createInfoField("creator", this.getInfo().getCreator());
                this.createInfoField("site", this.getInfo().getSite());
                this.addBorder(0, row, 1, 2);
            } else {
                this.skipRows(2);
            }
            this.setCol(1);
            row = this.getRow();
            if (this.data != null) {
                if (this.data.isModified()) {
                    this.createInfoField("type", "Unsaved Raster");
                } else {
                    this.createInfoField("type", oh.getTypeDesc());
                }
            } else {
                this.createInfoField("type", "unknown");
            }
            this.createField("maximum iteration", "MaxIt");
            this.createField("minimum iteration", "MinIt");
            this.createInfoField("time", MandelImageAreaDialog.formatTime(this.getInfo().getTime()));
            this.createField("number of iterations", "NumIt");
            this.addBorder(1, row, 1, 5);
            if (this.data != null) {
                row = this.getRow();
                if (this.data.getInfo().hasMandelCount()) {
                    this.createField("mandel set pixels", "MCnt");
                    double cov = (double)this.getInfo().getMCnt() / (double)this.getInfo().getRX() / (double)this.getInfo().getRY();
                    cov = (double)Math.round(cov * 1000.0) / 10.0;
                    this.createInfoField("mandel set coverage", "" + cov + "%");
                } else {
                    this.skipRows(2);
                }
                this.addBorder(1, row, 1, 2);
                row = this.getRow();
                if (h.hasImageData()) {
                    String mapping = "";
                    if (h.hasMapping()) {
                        mapping = " (" + this.data.getMapping().getType() + ")";
                    }
                    if (h.hasMapper()) {
                        this.createInfoField("mapper", this.data.getMapper().getName() + mapping);
                        this.createInfoField("parameter", this.data.getMapper().getParamDesc());
                    } else {
                        this.createInfoField("mapper", "-");
                        this.createInfoField("parameter", "-");
                    }
                } else {
                    MandelHandle i;
                    String image = "no image data";
                    if (this.qname != null && (i = MandelImageAreaDialog.this.getEnvironment().getImageDataScanner().getMandelHandle(this.qname)) != null) {
                        image = i.getHeader().hasRaster() ? "raster available" : "image available";
                    }
                    this.createInfoField("image", image);
                }
                this.addBorder(1, row, 1, 2);
            }
            if (this.data != null && h.hasImageData()) {
                row = this.getRow();
                this.createInfoField("image", h.hasRaster() ? "raster" : "image");
                this.createInfoField("colormap size", h.hasColormap() ? "" + this.data.getColormap().getSize() : "-");
                this.addBorder(1, row, 1, 2);
            }
            row = this.getMaxGridRow();
            this.filename = new JTextField();
            this.add((Component)this.filename, this.GBC(0, row).setSpanW(this.getMaxGridCol() + 1).setFill(2).setInsets(10, 0, 0, 0).setWeight(200.0, 0.0));
            this.filename.setEditable(false);
            this.filename.setBorder(new BevelBorder(1));
        }

        protected void setupButtons() {
            super.setupButtons();
            if (!this.readonlyMode) {
                this.save = this.createButton("Save", "Save changes", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            MandelData orig = new MandelData(View.this.data.getFile());
                            if (Utils.equals(orig.getInfo().getLocation(), View.this.data.getInfo().getLocation()) && Utils.equals(orig.getInfo().getKeywords(), View.this.data.getInfo().getKeywords())) {
                                MandelImageAreaDialog.this.mandelInfo("data not changed");
                            } else {
                                try {
                                    orig.getInfo().setLocation(View.this.data.getInfo().getLocation());
                                    orig.getInfo().setKeywords(View.this.data.getInfo().getKeywords());
                                    orig.write();
                                }
                                catch (IOException ex) {
                                    MandelImageAreaDialog.this.mandelError("cannot write " + View.this.data.getFile() + ": " + ex);
                                }
                            }
                        }
                        catch (IOException ex) {
                            MandelImageAreaDialog.this.mandelError("cannot read " + View.this.data.getFile() + ": " + ex);
                        }
                    }
                });
            }
        }
    }
}

