/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.ControlDialog;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListModelSource;
import com.mandelsoft.mand.tool.MandelListPanel;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ctx.MandelListContextMenuHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.TablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class MandelListsDialog
extends ControlDialog {
    public MandelListsDialog(MandelWindowAccess owner) {
        super(owner, "Mandel Lists");
        Dimension d = new Dimension((int)this.getSize().getWidth() + 60, (int)this.getSize().getHeight());
        this.setSize(d);
        this.setMinimumSize(d);
        System.out.println("minimal size is " + this.getMinimumSize());
        this.setResizable(true);
    }

    protected void setup() {
        if (this.getEnvironment().getUnseenRastersModel() != null) {
            this.addTab("Unseen Images", new UnseenRasterPanel(), "Images not seen according to local seen file");
        }
        this.addTab("Variants", new VariantsPanel(), "Mandel areas with variants");
        if (this.getEnvironment().getFavoritesModel() != null) {
            this.addTab("Favorites", new FavoritesPanel(), "Images according local favorites file");
        }
        if (this.getEnvironment().getTodosModel() != null) {
            this.addTab("Todos", new TodosPanel(), "Images according local todo file");
        }
        this.addTab("History", new HistoryPanel(), "Display history of images");
        if (this.getEnvironment().getNewRastersModel() != null) {
            this.addTab("New Images", new NewRasterPanel(), "newly generated rasters not touched by anybody so far");
        }
        if (this.getEnvironment().getAreasModel() != null) {
            this.addTab("Key Areas", new AreasPanel(), "marked root areas for backward navigation");
        }
        if (this.getEnvironment().getRefinementsModel() != null) {
            this.addTab("Refinements", new RefinementsPanel(), "available refinements");
        }
    }

    private class RefinementsPanel
    extends MandelListPanel {
        public RefinementsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getRefinementsModel(), (ActionListener)null);
        }
    }

    private class AreasPanel
    extends MandelListPanel {
        public AreasPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getAreasModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryPanel
    extends TablePanel<MandelListTableModel>
    implements MandelListModelSource {
        private History history;
        private QualifiedMandelName mandelname;

        public HistoryPanel() {
            super(null, MandelListsDialog.this.getMandelWindowAccess().getHistory(), null);
            LoadAction load = new LoadAction();
            this.addActionListener(load);
            this.addButton("Load", load);
            this.addButton("Clear", new ClearAction());
            this.history = MandelListsDialog.this.getMandelWindowAccess().getHistory();
            this.setContextMenuHandler(new ContextHandler());
        }

        @Override
        protected void setSelection(int index, int col) {
            this.mandelname = ((MandelListTableModel)this.getModel()).getQualifiedName(index);
            System.out.println("model index: " + index + "(" + this.getTable().getSelectionModel().getMaxSelectionIndex() + "): " + this.mandelname);
        }

        private class ContextHandler
        extends MandelListContextMenuHandler
        implements TablePanel.ContextMenuHandler {
            private ContextHandler() {
            }

            public void handleContextMenu(JComponent comp, MouseEvent evt, int row, int col) {
                this.handleContextMenu(comp, evt, row);
            }

            protected JPopupMenu createContextMenu(Integer index) {
                QualifiedMandelName sel = null;
                MandelWindowAccess access = this.getMandelWindowAccess();
                MandelImagePanel mp = this.getMandelWindowAccess().getMandelImagePane();
                MandelListModel model = this.getModel();
                if (index < 0) {
                    return null;
                }
                sel = model.getQualifiedName(index);
                JPopupMenu menu = this.createLabeledMenu(sel.toString());
                MandelHandle h = model.getMandelHandle(index);
                menu.add(this.showMetaAction);
                if (h != null && h.getHeader().hasImageData()) {
                    menu.add(this.showImageAction);
                    if (mp != null) {
                        menu.add(this.loadImageAction);
                        if (sel.getQualifier() != null) {
                            menu.add(this.loadRegImageAction);
                        }
                    }
                }
                menu.add(this.addMemoryAction);
                Component comp = this.getContextComponent();
                menu.add(access.getEnvironment().getListActions().createMenu(comp, sel));
                return menu;
            }
        }

        private class ClearAction
        implements ActionListener {
            private ClearAction() {
            }

            public void actionPerformed(ActionEvent e) {
                ((MandelListTableModel)HistoryPanel.this.getModel()).clear();
            }
        }

        private class LoadAction
        implements ActionListener {
            private LoadAction() {
            }

            public void actionPerformed(ActionEvent e) {
                System.out.println("*** load history entry " + HistoryPanel.this.mandelname);
                if (HistoryPanel.this.mandelname == null) {
                    return;
                }
                HistoryPanel.this.setBusy(true);
                if (!MandelListsDialog.this.getMandelWindowAccess().getMandelImagePane().setImage(HistoryPanel.this.mandelname)) {
                    JOptionPane.showMessageDialog(HistoryPanel.this.getOwner(), "Cannot load image: " + HistoryPanel.this.mandelname, "Mandel IO", 2);
                }
                HistoryPanel.this.setBusy(false);
            }
        }
    }

    private class TodosPanel
    extends MandelListPanel {
        public TodosPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getTodosModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    private class FavoritesPanel
    extends MandelListPanel {
        public FavoritesPanel() {
            super(null, MandelListsDialog.this.getEnvironment().getFavoritesModel(), null, !MandelListsDialog.this.getEnvironment().isReadonly());
        }
    }

    private class VariantsPanel
    extends MandelListPanel {
        public VariantsPanel() {
            super((String)null, MandelListsDialog.this.getEnvironment().getVariantsModel(), (ActionListener)null);
        }
    }

    private class UnseenRasterPanel
    extends RefreshingPanel {
        public UnseenRasterPanel() {
            super(MandelListsDialog.this.getEnvironment().getUnseenRastersModel());
        }

        private class NewAction
        implements ActionListener {
            private NewAction() {
            }

            public void actionPerformed(ActionEvent e) {
                MandelList unseen = ((MandelListTableModel)UnseenRasterPanel.this.getModel()).getList();
                MandelList n = MandelListsDialog.this.getEnvironment().getNewRasters();
                n.refresh(false);
                MandelListsDialog.this.getEnvironment().refresh(unseen);
                unseen.retainAll(n);
                try {
                    unseen.save();
                }
                catch (IOException ex) {
                    System.err.println("cannot write seen: " + ex);
                }
                ((MandelListTableModel)UnseenRasterPanel.this.getModel()).fireTableDataChanged();
            }
        }
    }

    private class NewRasterPanel
    extends RefreshingPanel {
        public NewRasterPanel() {
            super(MandelListsDialog.this.getEnvironment().getNewRastersModel());
        }
    }

    private class RefreshingPanel
    extends MandelListPanel {
        public RefreshingPanel(MandelListTableModel model) {
            super((String)null, model, (ActionListener)null);
        }

        protected void setup(ActionListener action) {
            super.setup(new RefreshLoadAction());
        }

        protected class RefreshLoadAction
        extends MandelListPanel.LoadAction {
            protected RefreshLoadAction() {
            }

            protected void handleLoaded(QualifiedMandelName name) {
            }
        }
    }
}

