/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;

public class MandelSubAreaCreationDialog
extends MandelAreaCreationDialog {
    public MandelSubAreaCreationDialog(MandelWindowAccess owner, String title) {
        super(owner, title);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.handleClose();
        }
    }

    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new SubAreaView(name, (MandelInfo)info);
    }

    public void setRect(BufferedComponent.VisibleRect rect) {
        ((SubAreaView)this.getView()).setRect(rect);
    }

    public void setRectHandled() {
        ((SubAreaView)this.getView()).setRectHandled();
    }

    protected void handleClose() {
        ((SubAreaView)this.getView()).handleClose();
    }

    protected class SubAreaView
    extends MandelAreaCreationDialog.CreationView {
        private BufferedComponent.VisibleRect rect;
        private JButton namebutton;
        private JButton nextnamebutton;
        private JButton showbutton;

        public SubAreaView(QualifiedMandelName name, MandelInfo info) {
            super(name, info);
            MandelSubAreaCreationDialog.this.getDialog().addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    SubAreaView.this.handleClose();
                }

                public void windowClosed(WindowEvent e) {
                    System.out.println("closed sub area");
                }
            });
        }

        protected void handleClose() {
            System.out.println("closing sub area");
            if (this.rect != null) {
                System.out.println(" discard old rect");
                this.rect.discard();
                if (this.rect.getName() != null) {
                    MandelSubAreaCreationDialog.this.fireMandelAreaEvent(new MandelAreaCreationDialog.MandelAreaEvent(MandelSubAreaCreationDialog.this, 3));
                }
                this.rect = null;
            }
        }

        protected void setupButtons() {
            super.setupButtons();
            this.namebutton = this.createButton("Name", "Determine next free sub area name", new NameAction());
            this.nextnamebutton = this.createButton("Next", "Determine next free area name for given name", new NextNameAction());
            this.showbutton = this.createButton("Show", "Enable Area View", new ShowAction());
        }

        public void setFilename(String n, boolean modifiable) {
            super.setFilename(n, modifiable);
            this.namebutton.setEnabled(modifiable);
            this.nextnamebutton.setEnabled(modifiable);
        }

        protected final void determineNextFilename() {
            ToolEnvironment env = MandelSubAreaCreationDialog.this.getMandelFrame().getEnvironment();
            System.out.println("env=" + env);
            MandelFileName n = MandelFileName.create(new File(this.getFilename()));
            if (n == null) {
                this.Error("Sub Area Creation Problem", "Filename is no mandel file name");
                return;
            }
            MandelName sub = MandUtils.getNextName(n.getName(), env.getAutoMetaScanner());
            if (sub == null) {
                this.Error("Sub Area Creation Problem", "No further names available.");
            } else {
                File path = env.getInfoFolder(null);
                if (path == null) {
                    path = new File(".");
                }
                this.setFilename(new File(path, sub.getName() + ".md").getPath());
            }
        }

        protected final void determineFilename() {
            ToolEnvironment env = MandelSubAreaCreationDialog.this.getMandelFrame().getEnvironment();
            System.out.println("env=" + env);
            MandelName parent = MandelSubAreaCreationDialog.this.getMandelFrame().getMandelName();
            MandelName sub = MandUtils.getNextSubName(parent, env.getAutoMetaScanner());
            if (sub == null) {
                this.Error("Sub Area Creation Problem", "No further names available.");
            } else {
                File path = env.getInfoFolder(null);
                if (path == null) {
                    path = new File(".");
                }
                this.setFilename(new File(path, sub.getName() + ".md").getPath());
            }
        }

        protected void updateSlave() {
            System.out.println("update slave");
            if (this.rect != null) {
                this.updateRect(this.rect, this.getInfo());
            }
        }

        private void updateRect(BufferedComponent.VisibleRect rect, MandelInfo info) {
            MandelSubAreaCreationDialog.this.getMandelWindowAccess().getMandelImagePane().updateRect(rect, info);
        }

        public void setRectHandled() {
            this.rect = null;
        }

        public void setRect(BufferedComponent.VisibleRect rect) {
            if (this.rect != null && rect != this.rect) {
                this.handleClose();
            }
            if (rect == null) {
                this.setRectHandled();
                return;
            }
            MandelInfo info = (MandelInfo)rect.getOwner();
            if (rect.getName() != null) {
                if (rect == this.rect) {
                    MandUtils.round(info);
                }
                this.setInfo("Subarea " + rect.getName(), info);
            } else {
                MandUtils.round(info);
                this.setInfo("New Subarea", info);
            }
            if (this.automode && rect != this.rect) {
                this.determineFilename();
            }
            this.rect = rect;
        }

        protected BufferedComponent.VisibleRect getSelectedRect() {
            return this.rect;
        }

        private class ShowAction
        implements ActionListener {
            private ShowAction() {
            }

            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.rect.activate(true);
                SubAreaView.this.updateSlave();
                SubAreaView.this.rect.setVisible(true);
            }
        }

        private class NextNameAction
        implements ActionListener {
            private NextNameAction() {
            }

            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.determineNextFilename();
            }
        }

        private class NameAction
        implements ActionListener {
            private NameAction() {
            }

            public void actionPerformed(ActionEvent e) {
                SubAreaView.this.determineFilename();
            }
        }
    }
}

