/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.MandelList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class MandelTransferable
implements Transferable {
    public static final String mandelType = "application/x-java-jvm-local-objectref;class=" + MandelTransferable.class.getName();
    public static final DataFlavor mandelFlavor;
    private QualifiedMandelName[] names;
    private MandelList source;

    public MandelTransferable(QualifiedMandelName[] names) {
        this.names = names;
    }

    public MandelTransferable(MandelList src, QualifiedMandelName[] names) {
        this(names);
        this.source = src;
    }

    public QualifiedMandelName[] getNames() {
        return this.names;
    }

    public MandelList getSource() {
        return this.source;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(mandelFlavor)) {
            return this;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (QualifiedMandelName n : this.names) {
                sb.append(sep);
                sb.append(n.toString());
                sep = "\n";
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{mandelFlavor, DataFlavor.stringFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(mandelFlavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    static {
        try {
            mandelFlavor = new DataFlavor(mandelType);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("illegal drag and drop class: " + ex);
            throw new IllegalArgumentException("illegal drag and drop class", ex);
        }
    }
}

