/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.cm;

import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.Colormaps;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.cm.ColormapComponent;
import com.mandelsoft.swing.Dimensions;
import com.mandelsoft.swing.ScaleAdapter;
import com.mandelsoft.swing.ScaleEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ColormapDialog
extends MandelDialog {
    public static boolean debug = false;
    private ColormapComponent component;
    private JScrollPane scrollpane;
    private String name;
    private boolean adjusting;

    public ColormapDialog(MandelWindowAccess owner) {
        this(owner, "");
    }

    public ColormapDialog(MandelWindowAccess owner, String name) {
        this(owner, name, null);
    }

    public ColormapDialog(MandelWindowAccess owner, String name, ColormapModel model) {
        super(owner);
        this.name = name;
        this.setup(owner, model);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (debug) {
                    System.out.println("DRS: " + e);
                }
                if (!ColormapDialog.this.adjusting) {
                    ColormapDialog.this.setInitialSize();
                }
            }
        });
    }

    public ColormapDialog(MandelWindowAccess owner, String name, Colormap map, boolean modifiable) {
        this(owner, name);
        this.setColormap(map, modifiable);
    }

    private void setup(MandelWindowAccess owner, ColormapModel model) {
        this.component = new ColormapComponent(owner == null ? null : owner.getMandelWindow(), model);
        this.component.addScaleEventListener(new ScaleAdapter(){

            public void componentScaled(ScaleEvent e) {
                ColormapDialog.this.setTitle();
            }
        });
        this.scrollpane = new JScrollPane(this.component);
        Dimension d = this.getLimit();
        if (debug) {
            System.out.println("MAXIMUM=" + d);
        }
        this.setMaximumSize(d);
        this.scrollpane.setMaximumSize(d);
        this.scrollpane.getViewport().setMaximumSize(d);
        this.scrollpane.setBorder(null);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add(this.scrollpane);
        p.setMaximumSize(d);
        this.add(p);
        this.setInitialSize();
        this.setTitle();
    }

    private void setTitle() {
        String scale = "";
        if ((double)Math.round(this.component.getScaleX() / 3.0 * 100.0) != 100.0) {
            scale = " [" + Math.round(this.component.getScaleX() / 3.0 * 100.0) + "%]";
        }
        this.setTitle("Colormap " + this.name + scale);
    }

    public void hightLight(int ix) {
        this.component.highLight(ix);
    }

    public void setColormap(Colormap colormap, boolean modifiable) {
        this.component.getColormapModel().setColormap(colormap);
        this.component.getColormapModel().setModifiable(modifiable);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setInitialSize();
        }
        super.setVisible(b);
    }

    public void pack() {
        super.pack();
        this.setInitialSize();
    }

    public Dimension getLimit() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = this.getInsets();
        Dimensions.mod.sub(d, insets.left + insets.right, insets.top + insets.bottom);
        Dimensions.mod.sub(d, 10.0, 10.0);
        return d;
    }

    public void setInitialSize() {
        Dimension id = this.component.getPreferredSize();
        if (debug) {
            System.out.println("preferred: " + id);
        }
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = new Dimension(id);
        Insets insets = this.getInsets();
        Dimensions.mod.add(d, insets.left + insets.right, insets.top + insets.bottom);
        Dimensions.mod.sub(sd, 10.0, 10.0);
        Dimension od = new Dimension(d);
        Dimensions.mod.limit(d, sd);
        this.adjusting = true;
        if (d.getWidth() < od.getWidth()) {
            int h = (int)this.scrollpane.getHorizontalScrollBar().getMaximumSize().getHeight();
            if (debug) {
                System.out.println("bar=" + h);
            }
            d.setSize(d.getWidth(), d.getHeight() + (double)h);
        }
        if (debug) {
            System.out.println("*set size " + d);
        }
        this.setSize(d);
        this.adjusting = false;
    }

    public void revalidate() {
        this.component.revalidate();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    static class TestFrame
    extends JFrame {
        ColormapComponent cc;

        TestFrame() {
            this.setup();
        }

        void setup() {
            this.cc = new ColormapComponent(null);
            this.cc.getColormapModel().setColormap(new Colormaps.Simple(256, Color.BLUE, Color.WHITE));
            this.cc.getColormapModel().setModifiable(true);
            this.add(this.cc);
            this.pack();
            this.setResizable(false);
        }
    }
}

