/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.thumb;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.thumb.ImageChangeListenerSupport;
import com.mandelsoft.mand.tool.thumb.ImageSource;
import com.mandelsoft.mand.tool.thumb.ThumbnailFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThumbnailFactory
extends ImageChangeListenerSupport<QualifiedMandelName>
implements ThumbnailFactory {
    protected ThumbnailFactory.Client client;
    protected List<QualifiedMandelName> lifo;
    protected int maxcache = 20;
    protected HashMap<QualifiedMandelName, ImageSource<QualifiedMandelName>> thumbnails;

    protected AbstractThumbnailFactory(ThumbnailFactory.Client client) {
        this.client = client;
        this.thumbnails = new HashMap();
        this.lifo = new ArrayList<QualifiedMandelName>();
    }

    @Override
    public void setMaxcache(int maxcache) {
        this.maxcache = maxcache;
    }

    public int getMaxcache() {
        return this.maxcache;
    }

    @Override
    public void cleanupThumbnails() {
        HashSet<QualifiedMandelName> set = new HashSet<QualifiedMandelName>(this.thumbnails.keySet());
        for (QualifiedMandelName n : set) {
            if (this.client.usesThumbnail(n)) continue;
            this.remove(n);
        }
    }

    @Override
    public void remove(QualifiedMandelName name) {
        ImageSource<QualifiedMandelName> src = this.thumbnails.get(name);
        if (src != null) {
            src.cancel();
            this.thumbnails.remove(name);
        }
        this.lifo.remove(name);
    }
}

