/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.CompoundMandelScanner;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Updater
extends MandUtils {
    private int ccnt;
    private int ecnt;
    private int ucnt;

    public void printStat() {
        System.out.println("checked: " + this.ucnt);
        System.out.println("updated: " + this.ucnt);
        System.out.println("failed : " + this.ecnt);
    }

    void updateInfos(List<String> elems, MandelScanner scan, File target, Environment env) {
        this.handle(elems, scan, target, new UpdateInfoHandler(env));
    }

    void updateInfos(MandelScanner scan, File target, Environment env) {
        this.handle(scan, target, new UpdateInfoHandler(env));
    }

    void updateVersions(List<String> elems, MandelScanner scan, File target) {
        this.handle(elems, scan, target, new UpdateVersionHandler());
    }

    void updateVersions(MandelScanner scan, File target) {
        this.handle(scan, target, new UpdateVersionHandler());
    }

    void normalize(boolean nflag, boolean rflag, List<String> elems, MandelScanner scan, File target) {
        this.handle(elems, scan, target, new NormalizeHandler(nflag, rflag));
    }

    void normalize(boolean nflag, boolean rflag, MandelScanner scan, File target) {
        this.handle(scan, target, new NormalizeHandler(nflag, rflag));
    }

    void handle(List<String> elems, MandelScanner scan, File target, Handler handler) {
        for (String e : elems) {
            File f = new File(e);
            if (f.exists()) {
                handler.handle(f, target);
                continue;
            }
            MandelName name = MandelName.create(e);
            if (name != null) {
                for (MandelHandle h : scan.getMandelHandles(name)) {
                    if (!h.getFile().isFile()) continue;
                    ++this.ccnt;
                    handler.handle(h.getFile().getFile(), target);
                }
            }
            ColormapName cn = new ColormapName(f.getName());
            for (ColormapHandle h : scan.getColormapHandles(cn)) {
                if (!h.getFile().isFile()) continue;
                ++this.ccnt;
                handler.handle(h.getFile().getFile(), target);
            }
        }
    }

    void handle(MandelScanner scan, File target, Handler handler) {
        for (MandelName mandelName : scan.getMandelNames()) {
            for (MandelHandle mandelHandle : scan.getMandelHandles(mandelName)) {
                if (!mandelHandle.getFile().isFile()) continue;
                ++this.ccnt;
                handler.handle(mandelHandle.getFile().getFile(), target);
            }
        }
        for (ColormapName colormapName : scan.getColormapNames()) {
            for (ColormapHandle colormapHandle : scan.getColormapHandles(colormapName)) {
                if (!colormapHandle.getFile().isFile()) continue;
                ++this.ccnt;
                handler.handle(colormapHandle.getFile().getFile(), target);
            }
        }
    }

    public static void main(String[] args) {
        int c = 0;
        File targetdir = null;
        Updater upd = new Updater();
        boolean vflag = false;
        boolean nflag = false;
        boolean rflag = false;
        boolean iflag = false;
        CompoundMandelScanner sourcedirs = new CompoundMandelScanner();
        UpdateFilter filter = new UpdateFilter();
        ArrayList<String> elems = new ArrayList<String>();
        while (c < args.length && args[c].startsWith("-")) {
            String arg = args[c++];
            block19: for (int i = 1; i < arg.length(); ++i) {
                switch (arg.charAt(i)) {
                    case 'n': {
                        nflag = true;
                        continue block19;
                    }
                    case 'r': {
                        rflag = true;
                        continue block19;
                    }
                    case 'v': {
                        vflag = true;
                        continue block19;
                    }
                    case 'i': {
                        iflag = true;
                        continue block19;
                    }
                    case 'D': {
                        filter.setDflag(true);
                        continue block19;
                    }
                    case 'R': {
                        filter.setRflag(true);
                        continue block19;
                    }
                    case 'I': {
                        filter.setIflag(true);
                        continue block19;
                    }
                    case 'C': {
                        filter.setCflag(true);
                        continue block19;
                    }
                    case 'M': {
                        filter.setDflag(true);
                        filter.setIflag(true);
                        filter.setRflag(true);
                        continue block19;
                    }
                    case 'A': {
                        filter.setAflag(true);
                        continue block19;
                    }
                    case 't': {
                        if (c < args.length) {
                            targetdir = new File(args[c++]);
                            continue block19;
                        }
                        Command.Error("target directory missing");
                        continue block19;
                    }
                    case 'd': {
                        if (c < args.length) {
                            try {
                                sourcedirs.addScanner(new FolderMandelScanner(new File(args[c++]), null, false));
                            }
                            catch (IOException ex) {
                                Command.Error("illegal source directory: " + ex);
                            }
                            continue block19;
                        }
                        Command.Error("source directory missing");
                    }
                }
            }
        }
        try {
            Environment env = null;
            if (!sourcedirs.hasScanners()) {
                env = new Environment(null);
                sourcedirs.addScanner(env.getAllScanner());
                sourcedirs.addScanner(env.getColormapScanner());
            }
            sourcedirs.setFilter(filter);
            while (c < args.length) {
                elems.add(args[c++]);
            }
            if (vflag && nflag) {
                Command.Error("only -v or -n may be set");
            }
            if (iflag) {
                System.out.println("Update infos...");
                if (!elems.isEmpty()) {
                    upd.updateInfos(elems, sourcedirs, targetdir, env);
                } else {
                    upd.updateInfos(sourcedirs, targetdir, env);
                }
            }
            if (vflag) {
                System.out.println("Update Versions...");
                if (!elems.isEmpty()) {
                    upd.updateVersions(elems, sourcedirs, targetdir);
                } else {
                    upd.updateVersions(sourcedirs, targetdir);
                }
            }
            if (nflag || rflag) {
                System.out.println("Normalize Areas...");
                if (!elems.isEmpty()) {
                    upd.normalize(nflag, rflag, elems, sourcedirs, targetdir);
                } else {
                    upd.normalize(nflag, rflag, sourcedirs, targetdir);
                }
            }
            upd.printStat();
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
    }

    public static class UpdateFilter
    implements MandelScanner.Filter {
        private boolean Aflag = false;
        private boolean Dflag = false;
        private boolean Rflag = false;
        private boolean Iflag = false;
        private boolean Cflag = false;

        public boolean filter(MandelHeader h) {
            if (this.Aflag) {
                return true;
            }
            if (this.Cflag && h.isColormap()) {
                return true;
            }
            if (this.Iflag && h.isPlainImage()) {
                return true;
            }
            if (this.Rflag && h.hasRaster()) {
                return true;
            }
            return this.Dflag && h.isInfo();
        }

        public void setCflag(boolean Cflag) {
            this.Cflag = Cflag;
        }

        public void setDflag(boolean Dflag) {
            this.Dflag = Dflag;
        }

        public void setIflag(boolean Iflag) {
            this.Iflag = Iflag;
        }

        public void setRflag(boolean Rflag) {
            this.Rflag = Rflag;
        }

        public void setAflag(boolean Aflag) {
            this.Aflag = Aflag;
        }
    }

    public static interface Handler {
        public void handle(File var1, File var2);
    }

    class NormalizeHandler
    implements Handler {
        private boolean nflag;
        private boolean rflag;

        public NormalizeHandler() {
        }

        public NormalizeHandler(boolean nflag, boolean rflag) {
            this.nflag = nflag;
            this.rflag = rflag;
        }

        public void handle(File f, File target) {
            try {
                MandelData md = new MandelData(true, f);
                MandelInfo info = md.getInfo();
                File t = MandUtils.mapToInfoFile(new FileAbstractFile(f), target);
                if (!t.exists()) {
                    System.out.println("  " + f);
                    if (!info.valid()) {
                        System.out.println("  invalid: " + info.getMessage());
                        return;
                    }
                    if (this.nflag) {
                        MandUtils.normalize(info);
                    }
                    if (this.rflag) {
                        MandUtils.round(info);
                    }
                    MandelData n = new MandelData(info);
                    try {
                        Updater.this.ucnt++;
                        n.write(t);
                    }
                    catch (IOException io) {
                        Updater.this.ecnt++;
                        Command.Error("cannot write " + t);
                    }
                }
            }
            catch (IOException ex) {
                Command.Error("cannot read " + f);
            }
        }
    }

    class UpdateVersionHandler
    implements Handler {
        UpdateVersionHandler() {
        }

        public void handle(File f, File target) {
            try {
                MandelData md = new MandelData(f);
                if (!md.needsVersionUpdate()) {
                    System.out.println("version of " + f + " is up to date");
                    return;
                }
                System.out.println("update version of " + f);
                long lm = f.lastModified();
                if (target != null) {
                    File t = new File(target, f.getName());
                    try {
                        Updater.this.ucnt++;
                        md.write(t);
                        t.setLastModified(lm);
                    }
                    catch (IOException io) {
                        Updater.this.ecnt++;
                        Command.Error("cannot write " + t);
                    }
                } else {
                    try {
                        md.write();
                        f.setLastModified(lm);
                    }
                    catch (IOException io) {
                        Command.Error("cannot rewrite " + f);
                    }
                }
            }
            catch (IOException ex) {
                Command.Error("cannot read " + f);
            }
        }
    }

    class UpdateInfoHandler
    implements Handler {
        Environment env;
        String creator;
        String site;

        public UpdateInfoHandler(Environment env) {
            this.env = env;
            this.creator = env.getProperty("username");
            if (this.creator != null && this.creator.equals("ttt Krueger")) {
                this.creator = "Uwe Kr\u00fcger";
            }
            this.site = env.getProperty("sitename");
        }

        public Environment getEnvironment() {
            return this.env;
        }

        public void handle(File f, File target) {
            try {
                MandelData md = new MandelData(f);
                MandelInfo mi = md.getInfo();
                if (mi == null) {
                    return;
                }
                MandelInfo old = new MandelInfo().copyFrom(mi);
                this.update(md);
                if (mi.needsVersionUpdate()) {
                    mi.updateData(md);
                }
                if (mi.equals(old)) {
                    System.out.println(f + " is up to date (mcnt=" + mi.getMCnt() + ")");
                    return;
                }
                System.out.println("update info of " + f);
                System.out.println("  mcnt (" + mi.getVersion() + ")" + old.getMCnt() + "->" + mi.getMCnt());
                System.out.println("  cnt  (" + mi.getVersion() + ")" + old.getNumIt() + "->" + mi.getNumIt());
                long lm = f.lastModified();
                if (target != null) {
                    File t = new File(target, f.getName());
                    try {
                        md.write(t);
                        t.setLastModified(lm);
                    }
                    catch (IOException io) {
                        Command.Error("cannot write " + t);
                    }
                } else {
                    try {
                        Updater.this.ucnt++;
                        md.write();
                        f.setLastModified(lm);
                    }
                    catch (IOException io) {
                        Updater.this.ecnt++;
                        Command.Error("cannot rewrite " + f);
                    }
                }
            }
            catch (IOException ex) {
                Command.Error("cannot read " + f);
            }
        }

        public void update(MandelData data) {
            MandelRaster raster = data.getRaster();
            MandelInfo info = data.getInfo();
            if (raster == null) {
                return;
            }
            int limit = info.getLimitIt();
            int mcnt = 0;
            long cnt = 0L;
            int[][] r = raster.getRaster();
            int rx = raster.getRX();
            int ry = raster.getRY();
            for (int x = 0; x < rx; ++x) {
                for (int y = 0; y < ry; ++y) {
                    if (r[y][x] == 0) {
                        ++mcnt;
                        cnt += (long)limit;
                        continue;
                    }
                    cnt += (long)r[y][x];
                }
            }
            info.setMCnt(mcnt);
            if (this.getEnvironment() != null) {
                if (this.site != null && Utils.isEmpty(info.getSite())) {
                    info.setSite(this.site);
                }
                info.setCreator(this.creator);
            }
        }
    }
}

