/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.MandelList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaMandelList
extends AbstractList<QualifiedMandelName>
implements MandelList {
    private List<QualifiedMandelName> list = new ArrayList<QualifiedMandelName>();
    private MandelScanner scan;
    private MandelList base;

    public DeltaMandelList(MandelScanner scan, MandelList base) {
        this.scan = scan;
        this.base = base;
        this._refresh(true);
    }

    @Override
    public boolean contains(Object o) {
        System.out.println("delta contains " + o + ": " + !this.base.contains(o));
        return !this.base.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return !this.base.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        super.remove(o);
        return this.base.add((QualifiedMandelName)o);
    }

    @Override
    public boolean add(QualifiedMandelName e) {
        super.add(e);
        return this.base.remove(e);
    }

    @Override
    public QualifiedMandelName get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void add(int index, QualifiedMandelName element) {
        this.list.add(index, element);
        this.base.remove(element);
    }

    @Override
    public QualifiedMandelName remove(int index) {
        if (index < this.size()) {
            this.base.add(this.get(index));
        }
        return this.list.remove(index);
    }

    @Override
    public QualifiedMandelName set(int index, QualifiedMandelName element) {
        if (index < this.size()) {
            this.base.add(this.get(index));
        }
        this.base.remove(element);
        return this.list.set(index, element);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.scan.rescan(false);
        this.base.refresh(false);
        this.base.addAll(this.scan.getQualifiedMandelNames());
    }

    @Override
    public void refresh(boolean soft) {
        if (!soft) {
            this.scan.rescan(soft);
        }
        this._refresh(soft);
    }

    private void _refresh(boolean soft) {
        this.list.clear();
        this.base.refresh(soft);
        for (QualifiedMandelName n : this.scan.getQualifiedMandelNames()) {
            if (this.base.contains(n)) continue;
            this.list.add(n);
        }
    }

    @Override
    public void save() throws IOException {
        this.base.save();
    }

    @Override
    public boolean valid() {
        return this.base.valid();
    }

    @Override
    public void write(OutputStream os, String dst) throws IOException {
        MandelList.IO.write(this, os, dst);
    }

    @Override
    public void read(InputStream is, String src) throws IOException {
        MandelList.IO.read(this, is, src);
    }
}

