/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ContextMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandUtils
extends MandArith {
    public static final int PRECISION = 3;

    public static int toInt(double d) {
        return (int)Math.round(d);
    }

    public static int toInt(long l) {
        return (int)l;
    }

    public static String time(int d) {
        int h = d / 3600;
        int m = (d %= 3600) / 60;
        d %= 60;
        if (h != 0) {
            return h + ":" + m + ":" + d;
        }
        return m + ":" + d;
    }

    public static MandelName lookupRoot(MandelScanner scan, MandelSpec spec) {
        MandelName found = null;
        MandelName mn = MandelName.ROOT;
        while (mn != null) {
            MandelName s;
            found = mn;
            for (s = mn.sub(); s != null; s = s.next()) {
                try {
                    MandelInfo info;
                    MandelData md = scan.getMandelInfo(s).getInfo();
                    if (md == null || (info = md.getInfo()) == null || !info.contains(spec.getXM(), spec.getYM())) continue;
                    if (spec.getDX().compareTo(info.getDX()) < 0 || spec.getDY().compareTo(info.getDY()) < 0) break;
                    if (!info.isSameArea(spec)) continue;
                    return s;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            mn = s;
        }
        return found;
    }

    public static File mapFile(AbstractFile f, String dstSuf, File d) {
        String n = f.getName();
        if (!n.endsWith(dstSuf)) {
            int ix = n.lastIndexOf(46);
            n = ix >= 0 ? n.substring(0, ix) + dstSuf : n + dstSuf;
        }
        if (d != null) {
            return new File(d, n);
        }
        if (f.isFile()) {
            return new File(f.getFile().getParentFile(), n);
        }
        return null;
    }

    public static File mapToRasterName(AbstractFile f) {
        return MandUtils.mapFile(f, ".mr", null);
    }

    public static File mapToInfoName(AbstractFile f) {
        return MandUtils.mapFile(f, ".md", null);
    }

    public static File mapToRasterImageName(AbstractFile f) {
        return MandUtils.mapFile(f, ".mi", null);
    }

    public static File mapToImageName(AbstractFile f) {
        return MandUtils.mapFile(f, ".mpng", null);
    }

    public static File mapToRasterFile(AbstractFile f, File target) {
        return MandUtils.mapFile(f, ".mr", target);
    }

    public static File mapToInfoFile(AbstractFile f, File target) {
        return MandUtils.mapFile(f, ".md", target);
    }

    public static File mapToRasterImageFile(AbstractFile f, File target) {
        return MandUtils.mapFile(f, ".mi", target);
    }

    public static File mapToImageFile(AbstractFile f, File target) {
        return MandUtils.mapFile(f, ".mpng", target);
    }

    public static Set<MandelName> getSubNames(MandelName n, Set<MandelName> set) {
        HashSet<MandelName> sub = new HashSet<MandelName>();
        for (MandelName s : set) {
            if (!n.equals(s.getParentName())) continue;
            sub.add(s);
        }
        return set;
    }

    public static boolean hasSubNames(MandelName n, Set<MandelName> set) {
        for (MandelName s : set) {
            if (!n.equals(s.getParentName())) continue;
            return true;
        }
        return false;
    }

    public static Set<MandelName> getSubNames(MandelName n, MandelScanner scan) {
        if (scan instanceof ContextMandelScanner) {
            return ((ContextMandelScanner)scan).getSubNames(n);
        }
        return MandelScannerUtils.getSubNames(n, null, scan);
    }

    public static boolean hasSubNames(MandelName n, MandelScanner scan) {
        if (scan instanceof ContextMandelScanner) {
            return ((ContextMandelScanner)scan).hasSubNames(n);
        }
        return MandelScannerUtils.hasSubNames(n, null, scan);
    }

    public static boolean hasSubNames(MandelName n, MandelScanner scan, MandelScanner.Filter f) {
        if (scan instanceof ContextMandelScanner) {
            return ((ContextMandelScanner)scan).hasSubNames(n, f);
        }
        return MandelScannerUtils.hasSubNames(n, null, scan);
    }

    public static MandelName getNextSubName(MandelName n, Set<MandelName> set) {
        MandelName s;
        for (s = n.sub(); s != null && set.contains(s); s = s.next()) {
        }
        return s;
    }

    public static MandelName getNextSubName(MandelName n, MandelScanner scan) {
        return MandUtils.getNextSubName(n, scan, true);
    }

    public static MandelName getNextSubName(MandelName n, MandelScanner scan, boolean rescan) {
        MandelName s = n.sub();
        if (rescan) {
            scan.rescan(false);
        }
        while (s != null && scan.getMandelInfo(s) != null) {
            s = s.next();
        }
        return s;
    }

    public static MandelName getNextName(MandelName n, MandelScanner scan) {
        return MandUtils.getNextName(n, scan, true);
    }

    public static MandelName getNextName(MandelName s, MandelScanner scan, boolean rescan) {
        if (rescan) {
            scan.rescan(false);
        }
        for (s = s.next(); s != null && scan.getMandelInfo(s) != null; s = s.next()) {
        }
        return s;
    }

    public static MandelHandle better(MandelHandle a, MandelHandle b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        MandelHandle r = a;
        if (b.getHeader().hasRaster() && !a.getHeader().hasRaster()) {
            a = b;
        }
        if (b.getHeader().hasModifiableImage() && !a.getHeader().hasModifiableImage()) {
            a = b;
        }
        if (b.getQualifier() == null && a.getQualifier() != null) {
            a = b;
        }
        if (b.getHeader().hasAdditional(a.getHeader().getType()) && b.getQualifier() == null == (a.getQualifier() == null)) {
            a = b;
        }
        if (a == r && ((QualifiedMandelName)a.getName()).equals(b.getName())) {
            try {
                MandelData d1 = a.getInfo();
                MandelData d2 = b.getInfo();
                if (d2.getInfo().getLimitIt() > d1.getInfo().getLimitIt()) {
                    a = b;
                }
            }
            catch (IOException ex) {
                System.out.println("error reading info: " + ex);
            }
        }
        return a;
    }

    public static void adjustMandelInfo(MandelInfo info, Dimension raster) {
        if (raster.getWidth() / raster.getHeight() > (double)info.getRX() / (double)info.getRY()) {
            BigDecimal v = MandUtils.mul(info.getDY(), info.getRX());
            v = MandUtils.div(v, (double)info.getRY());
            v = MandUtils.mul(v, raster.getHeight());
            v = MandUtils.div(v, raster.getWidth());
            info.setDY(v);
        } else {
            BigDecimal v = MandUtils.mul(info.getDX(), info.getRY());
            v = MandUtils.div(v, (double)info.getRX());
            v = MandUtils.mul(v, raster.getWidth());
            v = MandUtils.div(v, raster.getHeight());
            info.setDX(v);
        }
        info.setRX(MandUtils.toInt(raster.getWidth()));
        info.setRY(MandUtils.toInt(raster.getHeight()));
    }

    public static void normalizeImageSize(MandelInfo info) {
        if (MandUtils.div(info.getDX(), info.getDY()).doubleValue() > (double)info.getRX() / (double)info.getRY()) {
            MandUtils.adjustHeight(info);
        } else {
            MandUtils.adjustWidth(info);
        }
    }

    public static void adjustHeight(MandelInfo info) {
        info.setRY((int)((double)info.getRX() * MandUtils.div(info.getDY(), info.getDX()).doubleValue()));
    }

    public static void adjustWidth(MandelInfo info) {
        info.setRX((int)((double)info.getRY() * MandUtils.div(info.getDX(), info.getDY()).doubleValue()));
    }

    public static void normalize(MandelInfo info) {
        if (MandUtils.div(info.getDX(), info.getDY()).doubleValue() > (double)info.getRX() / (double)info.getRY()) {
            MandUtils.adjustDY(info);
        } else {
            MandUtils.adjustDX(info);
        }
    }

    public static void adjustDX(MandelInfo info) {
        info.setDX(MandUtils.mul(info.getDY(), MandUtils.div((double)info.getRX(), (double)info.getRY())));
    }

    public static void adjustDY(MandelInfo info) {
        info.setDY(MandUtils.mul(info.getDX(), MandUtils.div((double)info.getRY(), (double)info.getRX())));
    }

    public static void round(MandelInfo info) {
        MandUtils.round(info, 3);
    }

    public static void round(MandelInfo info, int r) {
        info.setXM(MandUtils.round(info.getXM(), info.getDX(), info.getRX(), r));
        info.setYM(MandUtils.round(info.getYM(), info.getDY(), info.getRY(), r));
        info.setDX(MandUtils.round(info.getDX(), info.getDX(), info.getRX(), r));
        info.setDY(MandUtils.round(info.getDY(), info.getDY(), info.getRY(), r));
    }

    public static MandelInfo createRoot() {
        MandelInfo mi = new MandelInfo();
        mi.setXM(-0.55);
        mi.setYM(0.0);
        mi.setDX(4.0);
        mi.setDY(4.0);
        mi.setLimitIt(64000);
        mi.setRX(1000);
        mi.setRY(1000);
        return mi;
    }

    public static boolean isAbove(MandelName name, MandelList list) {
        for (QualifiedMandelName n : list) {
            if (!name.isAbove(n.getMandelName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAbove(MandelName name, MandelListFolder list) {
        for (QualifiedMandelName n : list.allentries()) {
            if (!name.isAbove(n.getMandelName())) continue;
            return true;
        }
        return false;
    }
}

