/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.ButtonPanel;
import com.mandelsoft.swing.GBC;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.GBCSupportPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class ActionPanel
extends GBCSupportPanel {
    private JPanel content;
    private JPanel buttons;
    private GBCPanel container;

    public ActionPanel() {
        BorderLayout lo = new BorderLayout();
        this.setLayout(lo);
        this.container = new GBCPanel();
        this.buttons = new ButtonPanel();
        super.add((Component)this.container, "Center");
        super.add((Component)this.buttons, "South");
        this.setContentPane(new GBCPanel());
    }

    public JPanel getContentPane() {
        return this.content;
    }

    public void setContentPane(JPanel c) {
        if (this.content != null) {
            this.container.remove(this.content);
        }
        this.content = c;
        if (this.content != null) {
            this.container.add((Component)c, this.GBC(0, 0, 1).setInsets(5));
        }
    }

    public JButton addButton(String txt, ActionListener l, String tooltip) {
        JButton b = this.addButton(txt, l);
        b.setToolTipText(tooltip);
        return b;
    }

    public JButton addButton(String txt, ActionListener l) {
        JButton b = new JButton(txt);
        b.addActionListener(l);
        return this.addButton(b);
    }

    public JButton addButton(Action action) {
        JButton b = new JButton(action);
        return this.addButton(b);
    }

    public JButton addButton(JButton b) {
        this.buttons.add(b);
        this.revalidate();
        return b;
    }

    public void addButton(JComponent m) {
        this.buttons.add(m);
        this.revalidate();
    }

    protected void removeButton(JButton b) {
        this.buttons.remove(b);
        this.revalidate();
    }

    public void addContent(JComponent c, Object o) {
        this.content.add((Component)c, o);
        this.content.revalidate();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    static class TestFrame
    extends JFrame {
        TestFrame() {
            ActionListener l = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("button clicked: " + e.getActionCommand());
                }
            };
            ActionPanel p = new ActionPanel();
            JLabel c = new JLabel("label laber blubber bla");
            c.setBorder(new BevelBorder(0));
            p.addContent(c, new GBC(0, 0).setWeight(10.0, 10.0).setFill(1));
            p.addButton("Test", l);
            this.add(p);
            this.pack();
            this.setMinimumSize(this.getSize());
        }
    }
}

