/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DnDListModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnDJList
extends JList {
    public static boolean debug = false;
    private ListTransferHandler transfer;
    private ContextMenuHandler ctxmenu;
    private Listener listener;

    public DnDJList() {
        this.setup();
    }

    public DnDJList(Vector<?> listData) {
        super(listData);
        this.setup();
    }

    public DnDJList(Object[] listData) {
        super(listData);
        this.setup();
    }

    public DnDJList(ListModel dataModel) {
        super(dataModel);
        this.setup();
    }

    private void setup() {
        this.transfer = this.createListTransferHandler();
        this.setTransferHandler(this.transfer);
        this.setDropMode();
    }

    public DnDListModel getModel() {
        return (DnDListModel)super.getModel();
    }

    public void setModel(ListModel dataModel) {
        this.setModel((DnDListModel)dataModel);
    }

    public void setModel(DnDListModel dataModel) {
        super.setModel(dataModel);
        this.setDropMode();
    }

    private void setDropMode() {
        DropMode mode = null;
        if (this.getModel() != null) {
            mode = this.getModel().getDropMode();
        }
        if (mode != null) {
            if (debug) {
                System.out.println("list: drop mode " + (Object)((Object)mode));
            }
            this.setDragEnabled(true);
            this.setDropMode(mode);
        } else {
            if (debug) {
                System.out.println("list: disable drop mode");
            }
            this.setDragEnabled(false);
        }
    }

    protected ListTransferHandler createListTransferHandler() {
        return new ListTransferHandler();
    }

    public synchronized void setContextMenuHandler(ContextMenuHandler h) {
        if (h == null) {
            if (this.ctxmenu != null) {
                this.removeMouseListener(this.listener);
            }
        } else if (this.ctxmenu == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.addMouseListener(this.listener);
        }
        this.ctxmenu = h;
    }

    public synchronized ContextMenuHandler getContextMenuHandler() {
        return this.ctxmenu;
    }

    public static interface ContextMenuHandler {
        public void handleContextMenu(JComponent var1, MouseEvent var2, int var3);
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        public void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger() && DnDJList.this.ctxmenu != null) {
                Point p = e.getPoint();
                int index = DnDJList.this.locationToIndex(p);
                if (debug) {
                    System.out.println("CTX POPUP at " + index);
                }
                DnDJList.this.ctxmenu.handleContextMenu(DnDJList.this, e, index);
            }
        }
    }

    protected class ListTransferHandler
    extends TransferHandler {
        private Transferable trans = null;

        protected ListTransferHandler() {
        }

        private DnDJList getList(Component comp) {
            if (comp instanceof JList) {
                return (DnDJList)comp;
            }
            Container c = (Container)comp;
            return (DnDJList)c.getComponent(0);
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            return this.getList(info.getComponent()).getModel().canImport(new DnDListModel.TransferSupport(info));
        }

        protected Transferable createTransferable(JComponent c) {
            this.trans = this.getList(c).getModel().createTransferable(new DnDListModel.DragLocation((DnDJList)c));
            return this.trans;
        }

        public int getSourceActions(JComponent c) {
            return this.getList(c).getModel().getSourceActions();
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            return this.getList(info.getComponent()).getModel().importData(new DnDListModel.TransferSupport(info));
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
            if (this.trans != null) {
                this.getList(c).getModel().exportDone(this.trans, action);
            }
            this.trans = null;
        }
    }

    public static class DefaultModel
    extends DefaultListModel
    implements DnDListModel {
        public DropMode getDropMode() {
            return null;
        }

        public int getSourceActions() {
            return 0;
        }

        public Transferable createTransferable(DnDListModel.DragLocation loc) {
            return null;
        }

        public void exportDone(Transferable data, int action) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean canImport(DnDListModel.TransferSupport info) {
            return false;
        }

        public boolean importData(DnDListModel.TransferSupport info) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

