/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.DataField;
import com.mandelsoft.swing.DoubleField;
import com.mandelsoft.swing.FormattedField;
import com.mandelsoft.swing.Utils;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberField
extends FormattedField
implements DataField<Number> {
    public NumberField(Number v) {
        super(v);
        this.setHorizontalAlignment(11);
    }

    public NumberField(Class<? extends Number> vclass, NumberFormat format) {
        super(vclass, format);
        this.setHorizontalAlignment(11);
    }

    public NumberField(Class<? extends Number> vclass) {
        this(vclass, null);
    }

    @Override
    public Number getValue() {
        return (Number)super.getValue();
    }

    public void setMinimumNumber(Number min) {
        if (min != null) {
            this.setMinimum((Comparable)Utils.convertValueToValueClass(min, this.getValueClass()));
        } else {
            super.setMinimum(null);
        }
    }

    public void setMaximumNumber(Number max) {
        if (max != null) {
            this.setMaximum((Comparable)Utils.convertValueToValueClass(max, this.getValueClass()));
        } else {
            super.setMaximum(null);
        }
    }

    public Number getMinimumNumber() {
        return (Number)((Object)this.getMinimum());
    }

    public Number getMaximumNumber() {
        return (Number)((Object)this.getMaximum());
    }

    @Override
    public Number getDataValue() {
        return this.getValue();
    }

    @Override
    public void setDataValue(Number v) {
        this.setValue(v);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestFrame frame = new TestFrame();
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }

    static class TestFrame
    extends JFrame {
        TestFrame() {
            PropertyChangeListener listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    NumberField f = (NumberField)evt.getSource();
                    Object v = evt.getNewValue();
                    if (v != null) {
                        System.out.println("=" + v.getClass() + "=" + v);
                    }
                }
            };
            JFormattedTextField tf0 = new JFormattedTextField((Object)"test");
            tf0.setColumns(10);
            DoubleField nf1 = new DoubleField();
            nf1.setValue(10.0);
            NumberField nf2 = new NumberField((Number)10);
            System.out.println(nf1.getValueClass());
            System.out.println(nf2.getValueClass());
            nf1.setColumns(10);
            nf1.setMinimum(Integer.valueOf(10));
            nf1.setValueHint("Value must at leat be 10.");
            nf1.setHorizontalAlignment(11);
            nf2.setColumns(10);
            nf2.setMaximum(Integer.valueOf(10));
            nf2.setValueHint("Value may not be greater than 10.");
            nf2.setHorizontalAlignment(10);
            NumberField nf3 = new NumberField(BigDecimal.class);
            nf3.setColumns(10);
            nf3.addPropertyChangeListener("value", listener);
            this.setLayout(new FlowLayout());
            this.add(tf0);
            this.add(nf1);
            this.add(nf2);
            this.add(nf3);
            this.pack();
        }
    }
}

