/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class RenderedComponent
extends JComponent {
    private JComponent effective;
    private CellRendererPane renderer;
    private boolean redispatch = true;
    private Listener listener = new Listener();

    public RenderedComponent() {
        super.setBorder(null);
        this.renderer = new CellRendererPane();
        this.add(this.renderer);
    }

    public boolean isRedispatch() {
        return this.redispatch;
    }

    public void setRedispatch(boolean redispatch) {
        if (redispatch != this.redispatch) {
            this.redispatch = redispatch;
            if (redispatch) {
                this.addMouseListener(this.listener);
                this.addMouseMotionListener(this.listener);
                this.addMouseWheelListener(this.listener);
            } else {
                this.removeMouseListener(this.listener);
                this.removeMouseMotionListener(this.listener);
                this.removeMouseWheelListener(this.listener);
            }
        }
    }

    public JComponent getEffective() {
        return this.effective;
    }

    public void setEffectiveComponent(JComponent effective) {
        this.effective = effective;
        effective.validate();
    }

    public void setBorder(Border border) {
        this.effective.setBorder(border);
    }

    public Dimension getPreferredSize() {
        return this.effective.getPreferredSize();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.effective.setBounds(0, 0, width, height);
        super.setBounds(x, y, width, height);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (!this.isOpaque()) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        this.renderer.paintComponent(g2, this.effective, this, 0, 0, this.effective.getWidth(), this.effective.getHeight(), true);
        this.renderer.remove(this.effective);
        g2.dispose();
    }

    private void redispatchMouseEvent(MouseEvent e) {
        Point glassPanePoint = e.getPoint();
        JComponent container = this.effective;
        this.renderer.add(this.effective);
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.effective);
        Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        if (component != null) {
            Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener,
    FocusListener {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            RenderedComponent.this.redispatchMouseEvent(e);
        }

        public void keyPressed(KeyEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void keyReleased(KeyEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void keyTyped(KeyEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void focusGained(FocusEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void focusLost(FocusEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

