/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.Corner;
import com.mandelsoft.swing.CornerSideCrossLink;
import java.awt.Cursor;

public class Side {
    public static final Side TOP = new Side("Top");
    public static final Side RIGHT = new Side("Right");
    public static final Side BOTTOM = new Side("Bottom");
    public static final Side LEFT = new Side("Left");
    private String name;
    private Side opposite;
    private Corner leftCorner;
    private Corner rightCorner;
    private Corner lowerCorner;
    private Corner higherCorner;
    private int cursor;

    static void setup() {
        TOP.setup(BOTTOM, Corner.TOP_LEFT, Corner.TOP_RIGHT, Corner.TOP_LEFT, 8);
        RIGHT.setup(LEFT, Corner.TOP_RIGHT, Corner.BOTTOM_RIGHT, Corner.TOP_RIGHT, 11);
        BOTTOM.setup(TOP, Corner.BOTTOM_RIGHT, Corner.BOTTOM_LEFT, Corner.BOTTOM_LEFT, 9);
        LEFT.setup(RIGHT, Corner.BOTTOM_LEFT, Corner.TOP_LEFT, Corner.TOP_LEFT, 10);
    }

    private Side(String name) {
        this.name = name;
    }

    private void setup(Side c, Corner l, Corner r, Corner lc, int cursor) {
        this.opposite = c;
        this.leftCorner = l;
        this.rightCorner = r;
        this.lowerCorner = lc;
        this.higherCorner = lc == l ? r : l;
        this.cursor = cursor;
        if (l == null) {
            throw new IllegalStateException(this.name + " l");
        }
        if (r == null) {
            throw new IllegalStateException(this.name + " r");
        }
    }

    public String getName() {
        return this.name;
    }

    public Side getOppositeSide() {
        return this.opposite;
    }

    public Corner getLeftCorner() {
        return this.leftCorner;
    }

    public Corner getRightCorner() {
        return this.rightCorner;
    }

    public Corner getLowerCorner() {
        return this.lowerCorner;
    }

    public Corner getHigherCorner() {
        return this.higherCorner;
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.cursor);
    }

    public String toString() {
        return "Side " + this.name;
    }

    static {
        CornerSideCrossLink.setup();
    }
}

