/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.PixelIterator;
import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;

public class MandIter
extends MandArith {
    private static BigDecimal br = new BigDecimal(5.0E-16);
    private static boolean useDLL;

    public static PixelIterator createPixelIterator(MandelInfo mi) {
        BigDecimal x0 = mi.getXMin();
        BigDecimal y0 = mi.getYMax();
        BigDecimal dx = mi.getDX();
        BigDecimal dy = mi.getDY();
        int rx = mi.getRX();
        int ry = mi.getRY();
        return MandIter.createPixelIterator(x0, y0, dx, dy, rx, ry, mi.getLimitIt());
    }

    public static PixelIterator createPixelIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
        if (MandIter.div(dx, (double)rx).compareTo(br) > 0 && MandIter.div(dy, (double)ry).compareTo(br) > 0) {
            System.out.println("double iteration mode");
            return new DoubleMandIterator(x0, y0, dx, dy, rx, ry, limit);
        }
        if (useDLL) {
            System.out.println("long double iteration mode");
            return new LongDoubleMandIterator(x0, y0, dx, dy, rx, ry, limit);
        }
        System.out.println("big decimal iteration mode");
        return new BigDecimalMandIterator(x0, y0, dx, dy, rx, ry, limit);
    }

    private static native int iter(String var0, String var1, String var2, String var3, String var4, int var5);

    private static native int iterP(String var0, String var1, String var2, String var3, String var4, int var5, int var6);

    private static int iter(BigDecimal sx, BigDecimal sy, BigDecimal cx, BigDecimal cy, BigDecimal bound, int limit) {
        if (useDLL) {
            System.out.println("using native(dll) mode");
            return MandIter.iterP(sx.toString(), sy.toString(), cx.toString(), cy.toString(), bound.toString(), limit, 100);
        }
        System.out.println("using BigDecimal mode");
        return BigDecimalMandIterator.iter(sx, sy, cx, cy, bound, limit);
    }

    public static void main(String[] args) {
        System.out.println("calling iter");
        int i = MandIter.iter(b0, b0, new BigDecimal(0.5), b0, b10, 128000);
        System.out.println("got " + i);
    }

    static {
        try {
            System.loadLibrary("gmp");
            System.loadLibrary("Mandelbrot");
            useDLL = true;
        }
        catch (UnsatisfiedLinkError le) {
            System.out.println("failed:" + le);
            useDLL = false;
        }
    }

    private static class BigDecimalMandIterator
    extends BigDecimalIterator {
        private int cnt;
        private BigDecimal bound = new BigDecimal(10.0);

        public BigDecimalMandIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(x0, y0, dx, dy, rx, ry, limit);
        }

        public int iter() {
            ++this.cnt;
            if (this.cnt % 100 == 0) {
                System.out.print(".");
                System.out.flush();
            }
            return BigDecimalMandIterator.iter(BigDecimal.ZERO, BigDecimal.ZERO, this.cx, this.cy, this.bound, this.limit);
        }

        public static int iter(BigDecimal sx, BigDecimal sy, BigDecimal cx, BigDecimal cy, BigDecimal bound, int limit) {
            BigDecimal x = sx;
            BigDecimal y = sy;
            BigDecimal x2 = MandArith.mul(x, x);
            BigDecimal y2 = MandArith.mul(y, y);
            int it = 0;
            while (MandArith.add(x2, y2).compareTo(bound) < 0 && ++it <= limit) {
                BigDecimal xn = MandArith.add(MandArith.sub(x2, y2), cx);
                BigDecimal yn = MandArith.add(MandArith.mul(MandArith.mul(MandArith.b2, x), y), cy);
                x = xn;
                x2 = MandArith.mul(x, x);
                y = yn;
                y2 = MandArith.mul(y, y);
            }
            return it;
        }
    }

    private static class LongDoubleMandIterator
    extends BigDecimalIterator {
        protected String bound = new BigDecimal(10.0).toString();
        protected String scx;
        protected String scy;

        public LongDoubleMandIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(x0, y0, dx, dy, rx, ry, limit);
            System.out.println("prec: " + this.precision);
        }

        public void setX(int x) {
            super.setX(x);
            this.scx = this.cx.toString();
        }

        public void setY(int y) {
            super.setY(y);
            this.scy = this.cy.toString();
        }

        public int iter() {
            return MandIter.iterP("0.0", "0.0", this.scx, this.scy, this.bound, this.limit, this.precision);
        }
    }

    private static abstract class BigDecimalIterator
    extends MandPixelIterator {
        protected BigDecimal dx;
        protected BigDecimal dy;
        protected BigDecimal drx;
        protected BigDecimal dry;
        protected BigDecimal x0;
        protected BigDecimal y0;
        protected BigDecimal cx;
        protected BigDecimal cy;

        public BigDecimalIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(rx, ry, limit, dx, dy);
            this.dx = dx;
            this.dy = dy;
            this.drx = new BigDecimal(rx);
            this.dry = new BigDecimal(ry);
            this.x0 = x0;
            this.y0 = y0;
        }

        public boolean isFast() {
            return false;
        }

        public void setX(int x) {
            this.cx = MandArith.add(this.x0, MandArith.div(MandArith.mul(this.dx, x), this.drx));
        }

        public void setY(int y) {
            this.cy = MandArith.sub(this.y0, MandArith.div(MandArith.mul(this.dy, y), this.dry));
        }
    }

    private static class DoubleMandIterator
    extends MandPixelIterator {
        private double bound = 10.0;
        private double dx;
        private double dy;
        private double x0;
        private double y0;
        private double drx;
        private double dry;
        private double cx;
        private double cy;

        public DoubleMandIterator(BigDecimal x0, BigDecimal y0, BigDecimal dx, BigDecimal dy, int rx, int ry, int limit) {
            super(rx, ry, limit, dx, dy);
            this.dx = dx.doubleValue();
            this.dy = dy.doubleValue();
            this.x0 = x0.doubleValue();
            this.y0 = y0.doubleValue();
            this.drx = rx;
            this.dry = ry;
        }

        public boolean isFast() {
            return true;
        }

        public void setX(int x) {
            this.cx = this.x0 + (double)x * this.dx / this.drx;
        }

        public void setY(int y) {
            this.cy = this.y0 - (double)y * this.dy / this.dry;
        }

        public int iter() {
            return DoubleMandIterator.iter(0.0, 0.0, this.cx, this.cy, this.bound, this.limit);
        }

        private static int iter(double x, double y, double px, double py, double bound, int limit) {
            double x2 = x * x;
            double y2 = y * y;
            int it = 0;
            while (x2 + y2 < bound && ++it <= limit) {
                double xn = x2 - y2 + px;
                double yn = 2.0 * x * y + py;
                x = xn;
                x2 = x * x;
                y = yn;
                y2 = y * y;
            }
            return it;
        }
    }

    private static abstract class MandPixelIterator
    implements PixelIterator {
        protected int limit;
        protected int rx;
        protected int ry;
        protected int precision;
        protected int magnification;

        public MandPixelIterator(MandelInfo mi) {
            this(mi.getRX(), mi.getRY(), mi.getLimitIt(), mi.getDX(), mi.getDY());
        }

        public MandPixelIterator(int rx, int ry, int limit, BigDecimal dx, BigDecimal dy) {
            this.limit = limit;
            this.rx = rx;
            this.ry = ry;
            this.setPrecision(dx, dy);
        }

        protected void setPrecision(BigDecimal dx, BigDecimal dy) {
            BigDecimal dX = MandArith.div(dx, (double)this.rx);
            BigDecimal dY = MandArith.div(dy, (double)this.ry);
            BigDecimal d = dX;
            if (dX.compareTo(dY) > 0) {
                d = dY;
            }
            int p = 0;
            while (d.compareTo(BigDecimal.ONE) < 0) {
                ++p;
                d = MandArith.mul(d, BigDecimal.TEN);
            }
            int prec = (p + 2) / 3 * 10;
            this.precision = (int)((double)(p + 2) / Math.log10(2.0));
            d = dx;
            if (dx.compareTo(dy) > 0) {
                d = dy;
            }
            p = 0;
            while (d.compareTo(BigDecimal.ONE) < 0) {
                ++p;
                d = MandArith.mul(d, BigDecimal.TEN);
            }
            this.magnification = p;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getMagnification() {
            return this.magnification;
        }
    }
}

