/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SyncFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(src));
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dst));
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = bis.read(buf)) > 0) {
                    bos.write(buf, 0, len);
                }
            }
            finally {
                bos.close();
                dst.setLastModified(src.lastModified());
            }
        }
        finally {
            bis.close();
        }
    }

    public static void sync(File dst, File src, boolean verbose) throws IOException {
        File[] list;
        if (dst.exists()) {
            if (dst.isDirectory() != src.isDirectory()) {
                throw new IOException("file type mismatch: " + src + "," + dst);
            }
            if (src.isFile() && src.lastModified() != dst.lastModified()) {
                System.out.println("copy " + src + " to " + dst);
                if (!verbose) {
                    SyncFiles.copyFile(src, dst);
                }
            } else {
                System.out.println("skipping " + src);
            }
        } else if (src.isDirectory()) {
            System.out.println("creating " + dst);
            if (!verbose) {
                dst.mkdirs();
            }
        } else {
            System.out.println("copy " + src + " to " + dst);
            if (!verbose) {
                SyncFiles.copyFile(src, dst);
            }
        }
        if (src.isDirectory() && (list = src.listFiles()) != null) {
            for (File n : list) {
                SyncFiles.sync(new File(dst, n.getName()), n, verbose);
            }
        }
    }

    public static void main(String[] args) {
        int c;
        boolean vflag = false;
        for (c = 0; c < args.length && args[c].equals("-v"); ++c) {
            vflag = true;
        }
        if (args.length - c != 2) {
            System.err.println("destination and source folder required.");
            System.exit(1);
        }
        try {
            File dst = new File(args[c + 0]);
            File src = new File(args[c + 1]);
            System.out.println("synching " + dst.getAbsolutePath() + " from " + src.getAbsolutePath());
            SyncFiles.sync(dst, src, vflag);
        }
        catch (IOException io) {
            System.err.println("" + io);
        }
    }
}

