/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.cm;

import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.ChangeListener;
import com.mandelsoft.util.StateChangeSupport;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Colormap
extends StateChangeSupport
implements ColormapSource {
    public static boolean debug = false;
    public static final int VERSION = 1;
    private int version = 1;
    private int size;
    private Color[] colormap;
    private boolean modifying;
    private boolean modified;

    protected Colormap(int size, boolean setup) {
        this.size = size;
        if (debug) {
            System.out.println("create color map size " + size);
        }
        this.colormap = new Color[size];
        if (setup) {
            this.setup();
        }
    }

    public Colormap(int size) {
        this(size, true);
    }

    public Colormap(Colormap map) {
        this(map.getSize(), false);
        for (int i = 0; i < this.size; ++i) {
            this.colormap[i] = map.colormap[i];
        }
    }

    public Colormap(DataInputStream dis) throws IOException {
        this(dis, true);
    }

    public Colormap(DataInputStream dis, boolean verbose) throws IOException {
        this.read(dis, verbose);
    }

    protected void setup() {
        int max = 0xFFFFFF;
        int n = this.size - 1;
        for (int i = 0; i <= n; ++i) {
            this.colormap[i] = new Color(max * i / n);
        }
    }

    public Colormap getColormap() {
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Color getColor(int i) {
        return this.colormap[i];
    }

    public int getRed(int i) {
        return this.colormap[i].getRed();
    }

    public int getGreen(int i) {
        return this.colormap[i].getGreen();
    }

    public int getBlue(int i) {
        return this.colormap[i].getBlue();
    }

    public void setColor(int i, Color c) {
        this.colormap[i] = c;
        this.modify();
    }

    public void setColor(int i, int rgb) {
        this.setColor(i, new Color(rgb));
    }

    public void setRed(int i, int v) {
        Color old = this.colormap[i];
        this.colormap[i] = new Color(v, old.getGreen(), old.getBlue());
        this.modify();
    }

    public void setGreen(int i, int v) {
        Color old = this.colormap[i];
        this.colormap[i] = new Color(old.getRed(), v, old.getBlue());
        this.modify();
    }

    public void setBlue(int i, int v) {
        Color old = this.colormap[i];
        this.colormap[i] = new Color(old.getRed(), old.getGreen(), v);
        this.modify();
    }

    public void endModification() {
        this.modifying = false;
        if (this.modified) {
            this.modify();
        }
    }

    protected void modify() {
        if (!this.modifying) {
            this.modified = false;
            this.fireChangeEvent();
        } else {
            this.modified = true;
        }
    }

    public void startModification() {
        this.modifying = true;
    }

    public boolean needsVersionUpdate() {
        return this.version != 1;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        this.write(dos, 1, verbose);
    }

    public void write(DataOutputStream dos, int v, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  writing colormap (" + this.size + ")...");
        }
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown colormap version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            dos.writeInt(this.colormap[i].getRGB());
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading colormap ...");
        }
        this.startModification();
        try {
            this.version = dis.readInt();
            switch (this.version) {
                case 1: {
                    this.readV1(dis);
                    return;
                }
                default: {
                    throw new IOException("unknown colormap version " + this.version);
                }
            }
        }
        finally {
            this.endModification();
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.size = dis.readInt();
        if (debug) {
            System.out.println("    size " + this.size);
        }
        this.colormap = new Color[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.colormap[i] = new Color(dis.readInt());
        }
    }

    public static abstract class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            this.handle((Colormap)e.getSource());
        }

        public abstract void handle(Colormap var1);
    }
}

