/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.mapping.ArrayMapping;
import com.mandelsoft.mand.mapping.MappingBuilder;
import com.mandelsoft.mand.mapping.MappingRepresentation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Mapping {
    private static final int VERSION = 1;
    private int version = 1;
    private int minIt;
    private int maxIt;
    private int target;
    private MappingRepresentation mapping;

    public Mapping() {
    }

    public Mapping(DataInputStream dis) throws IOException {
        this.read(dis);
    }

    public Mapping(MappingBuilder mb, MappingRepresentation mapping) {
        this(mb.getMinIt(), mb.getMaxIt(), mb.getTargetSize(), mapping);
    }

    public Mapping(int minIt, int maxIt, int target, int[] mapping) {
        this(minIt, maxIt, target, new ArrayMapping(mapping));
    }

    public Mapping(int minIt, int maxIt, int target, MappingRepresentation mapping) {
        this.maxIt = maxIt;
        this.minIt = minIt;
        this.target = target;
        this.mapping = mapping;
        if (mapping.getSize() != maxIt - minIt + 1) {
            throw new IllegalArgumentException("mapping representation size does not match");
        }
        this.version = this.getTargetSize() > 0 && this.getSourceSize() / this.getTargetSize() > 2 ? 2 : 1;
    }

    public int getTargetSize() {
        return this.target;
    }

    public int getSourceSize() {
        return this.maxIt - this.minIt + 1;
    }

    public int getMinIt() {
        return this.minIt;
    }

    public int getMaxIt() {
        return this.maxIt;
    }

    public int getColormapIndex(int iteration) {
        if (iteration == 0) {
            return 0;
        }
        try {
            return this.mapping.getColormapIndex(iteration - this.minIt);
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            if (iteration - this.minIt < 0) {
                System.out.println("invalid interation value " + iteration + " (min=" + this.minIt);
                return 0;
            }
            System.out.println("invalid interation value " + iteration + " (max=" + (this.minIt + this.mapping.getSize()));
            return this.mapping.getColormapIndex(this.getSourceSize() - 1);
        }
    }

    public int getInteration(int index, int start, boolean skip) {
        int end;
        if (start < this.minIt) {
            start = this.minIt;
        }
        if (skip) {
            while (start <= this.maxIt && this.mapping.getColormapIndex(start - this.minIt) == index) {
                ++start;
            }
        }
        while (start <= this.maxIt && this.mapping.getColormapIndex(start - this.minIt) != index) {
            ++start;
        }
        if (start > this.maxIt) {
            return 0;
        }
        for (end = start; end <= this.maxIt && this.mapping.getColormapIndex(end - this.minIt) == index; ++end) {
        }
        int m = (end + start) / 2;
        return m;
    }

    public String getType() {
        String name = this.mapping.getClass().getName();
        int ix = name.lastIndexOf(".");
        if (ix > 0) {
            return name.substring(ix + 1);
        }
        return name;
    }

    public boolean needsVersionUpdate() {
        return false;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  writing mapping (v" + this.version + ")...");
        }
        dos.writeInt(this.version);
        this._write(dos, this.version);
    }

    protected void _write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                this.writeV1(dos);
                break;
            }
            case 2: {
                this.writeV2(dos);
                break;
            }
            default: {
                throw new IOException("unknown mapping version " + v);
            }
        }
    }

    protected void writeV1(DataOutputStream dos) throws IOException {
        dos.writeInt(this.minIt);
        dos.writeInt(this.maxIt);
        dos.writeInt(this.target);
        for (int i = 0; i < this.mapping.getSize(); ++i) {
            dos.writeInt(this.mapping.getColormapIndex(i));
        }
    }

    protected void writeV2(DataOutputStream dos) throws IOException {
        dos.writeInt(this.minIt);
        dos.writeInt(this.maxIt);
        dos.writeInt(this.target);
        int count = 0;
        int value = this.mapping.getColormapIndex(0);
        for (int i = 0; i < this.mapping.getSize(); ++i) {
            if (this.mapping.getColormapIndex(i) == value) {
                ++count;
                continue;
            }
            dos.writeInt(count);
            dos.writeInt(value);
            count = 1;
            value = this.mapping.getColormapIndex(i);
        }
        if (count > 0) {
            dos.writeInt(count);
            dos.writeInt(value);
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading mapping...");
        }
        this.version = dis.readInt();
        this._read(dis, this.version);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
        switch (v) {
            case 1: {
                this.readV1(dis);
                break;
            }
            case 2: {
                this.readV2(dis);
                break;
            }
            default: {
                throw new IOException("unknown  mapping version " + v);
            }
        }
    }

    protected void readV1(DataInputStream dis) throws IOException {
        this.minIt = dis.readInt();
        this.maxIt = dis.readInt();
        this.target = dis.readInt();
        int[] mapping = new int[this.maxIt - this.minIt + 1];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = dis.readInt();
        }
        this.mapping = new ArrayMapping(mapping);
    }

    protected void readV2(DataInputStream dis) throws IOException {
        this.minIt = dis.readInt();
        this.maxIt = dis.readInt();
        this.target = dis.readInt();
        MappingBuilder mb = new MappingBuilder(this.minIt, this.maxIt, this.target);
        int value = -1;
        while (value != mb.getSourceSize() - 1) {
            int count = dis.readInt();
            int target = dis.readInt();
            if ((value += count) < 0) continue;
            mb.add(value, target);
        }
        this.mapping = mb.getSourceSize() < 2000000 ? mb.createArrayMapping() : mb.createTreeMapping();
    }
}

