/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.CachedMandelHandle;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.DefaultColormapHandle;
import com.mandelsoft.mand.scan.DefaultMandelHandle;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerSupport;
import com.mandelsoft.mand.util.MandUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FolderMandelScannerSupport
extends MandelScannerSupport {
    public static boolean debug = false;
    private Map<MandelName, Map<AbstractFile, MandelHandle>> mandels = new HashMap<MandelName, Map<AbstractFile, MandelHandle>>();
    private Map<ColormapName, Map<AbstractFile, ColormapHandle>> colmaps = new HashMap<ColormapName, Map<AbstractFile, ColormapHandle>>();
    private Map<AbstractFile, ElementHandle<?>> files = new HashMap();

    protected FolderMandelScannerSupport() {
        this(MandelScanner.HAS_IMAGEDATA);
    }

    protected FolderMandelScannerSupport(MandelScanner.Filter filter) {
        this(filter, true);
    }

    protected FolderMandelScannerSupport(MandelScanner.Filter filter, boolean setup) {
        super(filter);
    }

    @Override
    protected Set<MandelName> _getMandelNames() {
        if (debug) {
            System.out.println(this + " lookup mandel names ");
        }
        return this.mandels.keySet();
    }

    @Override
    protected Set<MandelHandle> _getMandelHandles(MandelName name) {
        if (debug) {
            System.out.println(this + " lookup headers " + name);
        }
        return this.valueSet(this.mandels, name);
    }

    @Override
    protected Set<ColormapName> _getColormapNames() {
        if (debug) {
            System.out.println(this + " lookup colmaps");
        }
        return this.colmaps.keySet();
    }

    @Override
    protected Set<ColormapHandle> _getColormapHandles(ColormapName name) {
        if (debug) {
            System.out.println(this + " lookup " + name);
        }
        return this.valueSet(this.colmaps, name);
    }

    @Override
    public synchronized Set<MandelHandle> getMandelHandles(MandelName name) {
        return this._getMandelHandles(name);
    }

    @Override
    public synchronized Set<ColormapHandle> getColormapHandles(ColormapName name) {
        return this._getColormapHandles(name);
    }

    @Override
    public synchronized MandelHandle getMandelInfo(MandelName name) {
        Map<AbstractFile, MandelHandle> sub;
        if (debug) {
            System.out.println(this + " lookup info " + name);
        }
        if ((sub = this.mandels.get(name)) == null) {
            return null;
        }
        HashSet<AbstractFile> set = new HashSet<AbstractFile>(sub.keySet());
        while (!set.isEmpty()) {
            ElementHandle best = null;
            for (AbstractFile f : set) {
                MandelHandle h = sub.get(f);
                if (!h.getHeader().hasInfo()) continue;
                best = MandUtils.better((MandelHandle)best, h);
            }
            if (best == null) break;
            try {
                return new CachedMandelHandle((MandelHandle)best).assertInfo();
            }
            catch (IOException ex) {
                set.remove(best.getFile());
            }
        }
        return null;
    }

    @Override
    public synchronized MandelHandle getMandelData(MandelName name) {
        Map<AbstractFile, MandelHandle> sub;
        if (debug) {
            System.out.println(this + " lookup data " + name);
        }
        if ((sub = this.mandels.get(name)) == null) {
            return null;
        }
        HashSet<AbstractFile> set = new HashSet<AbstractFile>(sub.keySet());
        while (!set.isEmpty()) {
            ElementHandle best = null;
            for (AbstractFile f : set) {
                MandelHandle h = sub.get(f);
                if (!h.getHeader().hasInfo()) continue;
                best = MandUtils.better((MandelHandle)best, h);
            }
            if (best == null) break;
            try {
                return new CachedMandelHandle((MandelHandle)best).assertData();
            }
            catch (IOException ex) {
                set.remove(best.getFile());
            }
        }
        return null;
    }

    protected void clear() {
        if (debug) {
            System.out.println("clearing " + this);
        }
        this.startUpdate(true);
        this.mandels.clear();
        this.files.clear();
        this.colmaps.clear();
        this.finishUpdate();
    }

    protected <K, H> Set<H> valueSet(Map<K, Map<AbstractFile, H>> map, K name) {
        Map<AbstractFile, H> sub = map.get(name);
        HashSet<Object> set = sub == null ? new HashSet() : new HashSet<H>(sub.values());
        return set;
    }

    public synchronized String toString() {
        String id = super.toString();
        int ix = id.lastIndexOf(64);
        id = ix >= 0 ? id.substring(ix) : "";
        return this.files.size() + "/" + this.mandels.size() + "/" + this.colmaps.size() + id;
    }

    protected void dump() {
        System.out.println(this.toString() + ":");
        this.dump(this.mandels);
    }

    protected <K, H> void dump(Map<K, Map<AbstractFile, H>> map) {
        for (K n : map.keySet()) {
            System.out.println("  " + n);
        }
    }

    protected <K, H extends ElementHandle<?>> void add(Map<K, Map<AbstractFile, H>> map, K name, H h) {
        Map<AbstractFile, H> sub = map.get(name);
        if (sub == null) {
            sub = new HashMap<AbstractFile, H>();
            map.put(name, sub);
        }
        sub.put(h.getFile(), h);
    }

    protected <K, H> H remove(Map<K, Map<AbstractFile, H>> map, K name, AbstractFile f) {
        H h = null;
        Map<AbstractFile, H> sub = map.get(name);
        if (sub != null) {
            h = sub.remove(f);
            if (sub.isEmpty()) {
                map.remove(name);
            }
            if (debug && h == null && debug) {
                System.out.println("    no sub entry found for " + f);
                for (AbstractFile n : sub.keySet()) {
                    System.out.println("      " + n);
                }
            }
        } else if (debug) {
            System.out.println("    no entry found for " + name);
            this.dump(map);
        }
        return h;
    }

    protected void add(MandelHandle h) {
        this.add(this.mandels, ((QualifiedMandelName)h.getName()).getMandelName(), h);
        this.files.put(h.getFile(), h);
        this.notifyAddMandelFile(h);
    }

    protected void add(ColormapHandle h) {
        this.add(this.colmaps, h.getName(), h);
        this.notifyAddColormap(h);
    }

    protected MandelHandle create(AbstractFile f, QualifiedMandelName n, MandelHeader h) {
        return new DefaultMandelHandle(f, n, h);
    }

    protected ColormapHandle create(AbstractFile f, ColormapName n, MandelHeader h) {
        return new DefaultColormapHandle(f, n, h);
    }

    protected void add(File f) {
        block9: {
            try {
                String base = f.getName();
                int ix = base.lastIndexOf(46);
                if (ix > 0) {
                    base = base.substring(0, ix);
                }
                MandelFileName n = null;
                boolean namedone = false;
                if (!this.providesColormaps()) {
                    namedone = true;
                    n = MandelFileName.create(f);
                }
                try {
                    MandelHeader h = MandelHeader.getHeader(f);
                    FileAbstractFile af = new FileAbstractFile(f);
                    if (!this.filter(h)) break block9;
                    if (h.isColormap()) {
                        this.add(this.create((AbstractFile)af, new ColormapName(base), h));
                        break block9;
                    }
                    if (n == null) {
                        if (namedone) {
                            return;
                        }
                        n = MandelFileName.create(f);
                    }
                    this.add(this.create((AbstractFile)af, n.getQualifiedName(), h));
                }
                catch (IOException io) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void remove(AbstractFile f) {
        try {
            ColormapName cn;
            ColormapHandle ch;
            String base = f.getName();
            int ix = base.lastIndexOf(46);
            if (ix > 0) {
                base = base.substring(0, ix);
            }
            MandelFileName n = MandelFileName.create(f);
            if (debug) {
                System.out.println(this.toString() + ": remove mandel file " + f + ": " + n);
            }
            if (this.files.remove(f) == null && debug) {
                System.out.println("  file not registered");
            }
            if (n != null) {
                MandelHandle mh = this.remove(this.mandels, n.getQualifiedName().getMandelName(), f);
                if (mh != null) {
                    this.notifyRemoveMandelFile(mh);
                } else if (debug) {
                    System.out.println("  header not registered");
                }
            }
            if ((ch = this.remove(this.colmaps, cn = new ColormapName(base), f)) != null) {
                this.notifyRemoveColormap(ch);
            } else if (debug) {
                System.out.println("  colormap not registerd");
            }
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

