/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.scan;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.Settings;
import com.mandelsoft.mand.scan.CompoundMandelScanner;
import com.mandelsoft.mand.scan.FolderMandelScanner;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerCache;
import com.mandelsoft.mand.scan.URLMandelScanner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;

public class PathMandelScanner
extends CompoundMandelScanner {
    public static boolean debug = true;

    public PathMandelScanner(String path, MandelScanner.Filter filter, boolean local) {
        this(null, path, filter, local, null);
    }

    public PathMandelScanner(Proxy proxy, String path, MandelScanner.Filter filter, boolean local) {
        this(proxy, path, filter, local, null);
    }

    public PathMandelScanner(String path, MandelScanner.Filter filter, boolean local, MandelScannerCache cache) {
        this(cache.getProxy(), path, filter, local, cache);
    }

    private PathMandelScanner(Proxy proxy, String path, MandelScanner.Filter filter, boolean local, MandelScannerCache cache) {
        if (path != null) {
            this.startSetup();
            StringTokenizer t = new StringTokenizer(path, ";");
            HashSet<Serializable> elements = new HashSet<Serializable>();
            if (debug) {
                System.out.println("found path " + path);
            }
            while (t.hasMoreTokens()) {
                MandelScanner s;
                String p = t.nextToken().trim();
                if (p.equals("")) continue;
                if (p.startsWith("http:") || p.startsWith("file:")) {
                    try {
                        URL url = new URL(p);
                        if (elements.contains(url)) continue;
                        elements.add(url);
                        if (debug) {
                            System.out.println("add path " + url);
                        }
                        if ((s = cache != null ? cache.getScanner(url, filter) : new URLMandelScanner(proxy, url, filter)) == null) continue;
                        this.addScanner(s);
                    }
                    catch (MalformedURLException ex) {
                        System.out.println(p + ": " + ex);
                    }
                    continue;
                }
                if (!local) {
                    throw new RuntimeException("file paths not allowed for remote repositories");
                }
                try {
                    File f = new File(p).getCanonicalFile();
                    if (!f.exists() || elements.contains(f)) continue;
                    elements.add(f);
                    if (debug) {
                        System.out.println("add path " + f);
                    }
                    if ((s = cache != null ? cache.getScanner(f, filter) : new FolderMandelScanner(f, filter)) == null) continue;
                    this.addScanner(s);
                }
                catch (IOException io) {
                    if (!debug) continue;
                    System.out.println("ignoring " + p + ": " + io);
                }
            }
            if (debug) {
                System.out.println("path done");
            }
        }
        this.finishSetup();
    }

    public static void main(String[] args) {
        String p = null;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                p = p == null ? args[i] : p + ";" + args[i];
            }
        } else {
            try {
                Settings s = Settings.getSettings();
                p = s.getProperty("mandtool.path");
            }
            catch (IOException ex) {
                System.out.println("cannot read mandel settings");
            }
        }
        if (p != null) {
            PathMandelScanner ms = new PathMandelScanner(p, MandelScanner.HAS_IMAGEDATA, true);
            for (MandelName n : ms.getMandelNames()) {
                for (MandelHandle h : ms.getMandelHandles(n)) {
                    System.out.println(n + ": " + h.getHeader().getTypeDesc() + ": " + h.getFile());
                }
            }
        } else {
            System.out.println("no path found");
        }
    }
}

