/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.mand.srv.CalcRequest;
import com.mandelsoft.mand.srv.RequestBuffer;
import com.mandelsoft.util.Queue;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor {
    private RequestBuffer<CalcRequest> buffer = new RequestBuffer();
    private Queue<CalcRequest> queue = this.buffer.getRequestView();
    private Queue<CalcRequest> done = this.buffer.getDoneView();
    private List<Worker> workers = new ArrayList<Worker>();
    private boolean log;

    public RequestProcessor(int n) {
        while (n-- > 0) {
            Worker w = new Worker();
            this.workers.add(w);
            w.start();
        }
    }

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    public synchronized void sendRequest(CalcRequest req) {
        this.queue.put(req);
    }

    public synchronized void syncEmpty() throws InterruptedException {
        this.buffer.syncEmpty();
    }

    public synchronized CalcRequest getNextAction() throws InterruptedException {
        return this.buffer.getNextAction();
    }

    public synchronized CalcRequest testAndGetAnswer() {
        return this.buffer.testAndGetDone();
    }

    protected synchronized Queue<CalcRequest> getDoneView() {
        return this.done;
    }

    private class Worker
    extends Thread {
        private boolean abort = false;

        private Worker() {
        }

        public void abort() {
            this.abort = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    try {
                        RequestProcessor.this.log("worker: pull");
                        CalcRequest req = (CalcRequest)RequestProcessor.this.queue.pull();
                        RequestProcessor.this.log("worker: calc " + req.getReqId());
                        req.calc();
                        RequestProcessor.this.log("worker: done " + req.getReqId());
                        RequestProcessor.this.done.put(req);
                        RequestProcessor.this.log("worker: cont ");
                    }
                    catch (InterruptedException ex) {
                        System.out.println("worker: interrupted");
                    }
                } while (!this.abort);
            }
            finally {
                System.out.println("worker: abort");
            }
        }
    }
}

