/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv.tcp;

import com.mandelsoft.mand.srv.tcp.ClientData;
import com.mandelsoft.mand.srv.tcp.Statistic;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ServerData {
    public static final int VERSION = 1;
    private Statistic stat = new Statistic();
    private long totimg;
    private long imgcnt;

    protected synchronized void addImage() {
        ++this.imgcnt;
        ++this.totimg;
    }

    protected synchronized void removeImage() {
        --this.imgcnt;
    }

    protected synchronized void requestDone(ClientData client) {
        this.stat.requestDone();
        client.requestDone();
    }

    protected synchronized void removeConnection(ClientData client) {
        this.stat.removeConnection();
        client.removeConnection();
    }

    protected synchronized long notifyContact(ClientData client) {
        client.notifyContact();
        return this.stat.notifyContact();
    }

    public long getImageCnt() {
        return this.imgcnt;
    }

    public long getTotalImageCnt() {
        return this.totimg;
    }

    public synchronized long getTimeouts() {
        return this.stat.getTimeouts();
    }

    public synchronized long getRequestCnt() {
        return this.stat.getRequestCnt();
    }

    public synchronized long getPending() {
        return this.stat.getPending();
    }

    public synchronized long getLastTimeout() {
        return this.stat.getLastTimeout();
    }

    public synchronized long getLastRequest() {
        return this.stat.getLastRequest();
    }

    public synchronized long getLastError() {
        return this.stat.getLastError();
    }

    public synchronized long getLastContact() {
        return this.stat.getLastContact();
    }

    public synchronized long getLastConnected() {
        return this.stat.getLastConnected();
    }

    public synchronized long getErrors() {
        return this.stat.getErrors();
    }

    public synchronized long getTotalConCnt() {
        return this.stat.getTotalConCnt();
    }

    public synchronized long getConCnt() {
        return this.stat.getConCnt();
    }

    protected synchronized void addTimeout(ClientData client) {
        client.addTimeout();
        this.stat.addTimeout();
    }

    protected synchronized void addRequest(ClientData client) {
        client.addRequest();
        this.stat.addRequest();
    }

    protected synchronized void addError(ClientData client) {
        client.addError();
        this.stat.addError();
    }

    protected synchronized void addConnection(ClientData client) {
        client.addConnection();
        this.stat.addConnection();
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 1);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            default: {
                throw new IOException("unknown host info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        this.stat.write(dos);
        dos.writeLong(this.totimg);
        dos.writeLong(this.imgcnt);
    }

    public void read(DataInputStream dis) throws IOException {
        int version = dis.readInt();
        switch (version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            default: {
                throw new IOException("unknown host data version " + version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.stat.read(dis);
        this.totimg = dis.readLong();
        this.imgcnt = dis.readLong();
    }
}

