/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.util.ColorList;
import com.mandelsoft.swing.ChangeListenerSupport;
import java.awt.Color;
import java.io.IOException;
import javax.swing.event.ChangeEvent;

public class ColorListModel
extends ChangeListenerSupport {
    private ColorList list;
    private boolean autosave;

    public ColorListModel(ColorList list) {
        this.list = list;
    }

    public boolean isAutosave() {
        return this.autosave;
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
    }

    public ColorList getList() {
        return this.list;
    }

    public boolean addColor(Color c) {
        boolean a = this.list.add(c);
        if (a) {
            this.fire(c, 1);
        }
        return a;
    }

    public boolean addColor(int index, Color c) {
        if (!this.list.contains(c)) {
            this.list.add(index, c);
            this.fire(c, 1);
            return true;
        }
        return false;
    }

    public boolean removeColor(Color c) {
        boolean a = this.list.remove(c);
        if (a) {
            this.fire(c, 2);
        }
        return a;
    }

    protected void fire(Color c, int mode) {
        ListEvent e = new ListEvent(c, mode);
        if (this.autosave) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                System.err.println("cannot save color list " + ex);
            }
        }
        this.fireChangeEvent(e);
    }

    public class ListEvent
    extends ChangeEvent {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        private Color color;
        private int mode;

        protected ListEvent(Color c, int mode) {
            super(ColorListModel.this);
            this.color = c;
            this.mode = mode;
        }

        public Color getColor() {
            return this.color;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

