/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ContextMandelScanner;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListTableModel;
import com.mandelsoft.mand.tool.MandelListListener;
import com.mandelsoft.mand.tool.MandelListListenerSupport;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.util.MandelList;
import java.io.IOException;
import javax.swing.JOptionPane;

public class DefaultMandelListTableModel
extends AbstractMandelListTableModel
implements MandelListTableModel {
    protected MandelList list;
    protected MandelScanner scanner;
    private MandelListListenerSupport listeners = new MandelListListenerSupport();
    private boolean duplicates;
    private boolean inupdate;

    protected DefaultMandelListTableModel() {
    }

    public DefaultMandelListTableModel(MandelList list, MandelScanner scanner) {
        this();
        this.scanner = scanner;
        this.list = list;
        if (scanner instanceof ContextMandelScanner) {
            this.setShowLocation(((ContextMandelScanner)scanner).getContext().hasNested());
        }
    }

    public void removeMandelListListener(MandelListListener h) {
        this.listeners.removeMandelListListener(h);
    }

    public void addMandelListListener(MandelListListener h) {
        this.listeners.addMandelListListener(h);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
        this.fireListChanged();
    }

    protected void fireListChanged() {
        this.listeners.fireChangeEvent(this);
    }

    public void setDuplicates(boolean m) {
        this.duplicates = m;
    }

    public boolean allowDuplicates() {
        return this.duplicates;
    }

    public MandelScanner getMandelScanner() {
        return this.scanner;
    }

    protected boolean isInUpdate() {
        return this.inupdate;
    }

    public void add(QualifiedMandelName name) {
        this.checkModifiable();
        if (this.duplicates || !this.list.contains(name)) {
            int max = this.list.size();
            this.list.add(name);
            if (this.list.size() != max) {
                try {
                    this.list.save();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
                }
                int index = max;
                this.fireTableRowsInserted(index, index);
                this.fireListChanged();
            }
        }
    }

    public void add(int index, QualifiedMandelName name) {
        if (index >= this.list.size()) {
            this.add(name);
        }
        this.checkModifiable();
        if (this.duplicates || !this.list.contains(name)) {
            int max = this.list.size();
            this.list.add(index, name);
            if (this.list.size() != max) {
                try {
                    this.list.save();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
                }
                this.fireTableRowsInserted(index, index);
                this.fireListChanged();
            }
        }
    }

    public void addAll(QualifiedMandelName[] names) {
        int cnt = 0;
        this.checkModifiable();
        int max = this.list.size();
        for (QualifiedMandelName name : names) {
            if (!this.duplicates && this.list.contains(name)) continue;
            this.list.add(name);
            if (this.list.size() == max + cnt) continue;
            ++cnt;
        }
        if (cnt != 0) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            int index = this.list.size();
            this.fireTableRowsInserted(index - cnt, index - 1);
            this.fireListChanged();
        }
    }

    public void addAll(int index, QualifiedMandelName[] names) {
        int cnt = 0;
        if (index >= this.list.size()) {
            this.addAll(names);
        }
        this.checkModifiable();
        int max = this.list.size();
        for (QualifiedMandelName name : names) {
            if (!this.duplicates && this.list.contains(name)) continue;
            this.list.add(index + cnt, name);
            if (this.list.size() == max + cnt) continue;
            ++cnt;
        }
        if (cnt != 0) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            this.fireTableRowsInserted(index, index + cnt - 1);
            this.fireListChanged();
        }
    }

    public void remove(QualifiedMandelName name) {
        this.checkModifiable();
        int index = this.list.indexOf(name);
        if (index >= 0) {
            this.list.remove(index);
            if (!this.list.contains(name)) {
                this.cleanupThumbnail(name);
            }
            try {
                this.list.save();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot save list: " + ex, "Error", 0);
            }
            this.fireTableRowsDeleted(index, index);
            this.fireListChanged();
        }
    }

    public MandelList getList() {
        return this.list;
    }

    public void setList(MandelList list) {
        this.list = list;
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean soft) {
        if (!this.inupdate) {
            this.inupdate = true;
            try {
                if (debug) {
                    System.out.println("refresh " + this + " soft=" + soft);
                }
                this.list.refresh(soft);
                this.fireTableDataChanged();
            }
            finally {
                this.inupdate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Environment env) {
        if (!this.inupdate) {
            this.inupdate = true;
            try {
                env.refresh(this.list);
                this.fireTableDataChanged();
            }
            finally {
                this.inupdate = false;
            }
        }
    }

    public void clear() {
        this.getList().clear();
        this.fireTableDataChanged();
    }
}

