/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.swing.BufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class IterationPathDialog
extends MandelDialog {
    private BufferedComponent bc;
    private BufferedImage image;
    private JPanel panel;
    private Colormap colormap;
    private double BOUND = 10.0;
    private double jx;
    private double jy;
    private double xm;
    private double ym;
    private double dx;
    private double dy;
    private int rx;
    private int ry;
    private double x0;
    private double y0;
    private int limit;
    private double drx;
    private double dry;

    public IterationPathDialog(MandelWindowAccess frame, int w, int h) {
        super(frame);
        this.setTitle("Julia Test");
        this.panel = new IterationPathPanel();
        this.image = new BufferedImage(w, h, 1);
        this.panel.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.add(this.panel);
        this.pack();
        this.setResizable(true);
    }

    public void update(int limit, double x, double y) {
        this.colormap = this.getMandelWindowAccess().getMandelImage().getColormap();
        this.jx = x;
        this.jy = y;
        this.limit = limit;
        this.updateImage();
    }

    private void updateImage() {
        System.out.println("update image x=" + this.jx + ", y=" + this.jy);
        this.setupContext();
        Graphics2D g = this.image.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.calc();
        this.repaint();
    }

    private void setupContext() {
        this.xm = 0.0;
        this.ym = 0.0;
        this.dx = 2.0;
        this.rx = this.image.getWidth();
        this.ry = this.image.getHeight();
        this.dy = this.dx * (double)this.ry / (double)this.rx;
        this.drx = this.rx;
        this.dry = this.ry;
        this.x0 = this.xm - this.dx / 2.0;
        this.y0 = this.ym + this.dy / 2.0;
    }

    private void calc() {
        int i = this.iter(0.0, 0.0, this.jx, this.jy);
    }

    private int map(int i) {
        if (i > this.limit) {
            return 0;
        }
        return 1 + i % (this.colormap.getSize() - 1);
    }

    private int iter(double x, double y, double px, double py) {
        double x2 = x * x;
        double y2 = y * y;
        int it = 0;
        while (x2 + y2 < this.BOUND && ++it <= this.limit) {
            double xn = x2 - y2 + px;
            double yn = 2.0 * x * y + py;
            x = xn;
            x2 = x * x;
            y = yn;
            y2 = y * y;
            int ix = (int)((x - this.x0) * this.drx / this.dx);
            int iy = (int)((this.y0 - y) * this.dry / this.dy);
            if (ix < 0 || ix >= this.image.getWidth() || iy < 0 || iy >= this.image.getHeight()) continue;
            this.image.setRGB(ix, iy, this.colormap.getColor(this.map(it)).getRGB());
        }
        return it;
    }

    private class IterationPathPanel
    extends JPanel {
        private IterationPathPanel() {
        }

        protected void paintComponent(Graphics g) {
            Rectangle r = this.getVisibleRect();
            if (r.getWidth() != (double)IterationPathDialog.this.image.getWidth() || r.getHeight() != (double)IterationPathDialog.this.image.getHeight()) {
                IterationPathDialog.this.image = new BufferedImage((int)r.getWidth(), (int)r.getHeight(), 1);
                IterationPathDialog.this.updateImage();
            }
            g.drawImage(IterationPathDialog.this.image, 0, 0, null);
        }
    }
}

