/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelFolderTransferable
implements Transferable {
    public static final String folderType = "application/x-java-jvm-local-objectref;class=" + MandelFolderTransferable.class.getName();
    public static final DataFlavor folderFlavor;
    private MandelListFolder[] folders;
    private MandelListFolderTree source;

    public MandelFolderTransferable(MandelListFolderTree source, MandelListFolder[] folders) {
        System.out.println("create folder transfer");
        this.folders = folders;
        this.source = source;
    }

    public MandelListFolderTree getSource() {
        return this.source;
    }

    public MandelListFolder[] getFolders() {
        return this.folders;
    }

    private void add(List<QualifiedMandelName> list, MandelListFolder f) {
        list.addAll(f.getMandelList());
        for (MandelListFolder s : f) {
            this.add(list, s);
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(folderFlavor)) {
            return this;
        }
        if (flavor.equals(MandelTransferable.mandelFlavor)) {
            ArrayList<QualifiedMandelName> list = new ArrayList<QualifiedMandelName>();
            for (MandelListFolder f : this.folders) {
                this.add(list, f);
            }
            return new MandelTransferable(list.toArray(new QualifiedMandelName[list.size()]));
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            for (MandelListFolder f : this.folders) {
                sb.append(sep);
                sb.append(f.getName());
                sep = "\n";
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{folderFlavor, MandelTransferable.mandelFlavor, DataFlavor.stringFlavor};
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(folderFlavor) || flavor.equals(DataFlavor.stringFlavor) || flavor.equals(MandelTransferable.mandelFlavor);
    }

    static {
        try {
            folderFlavor = new DataFlavor(folderType);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("illegal drag and drop class: " + ex);
            throw new IllegalArgumentException("illegal drag and drop class", ex);
        }
    }
}

