/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.MandelFolderTransferable;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelListener;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.swing.DnDTreeModel;
import com.mandelsoft.swing.TreeModelListenerSupport;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class MandelListFolderTreeModelSupport
extends TreeModelListenerSupport
implements MandelListFolderTreeModel {
    private static final boolean debug = false;
    protected Map<MandelListFolder, MandelListTableModel> listmodels = new HashMap<MandelListFolder, MandelListTableModel>();
    protected boolean moving;

    protected MandelListFolderTreeModelSupport() {
    }

    public void clear() {
        this.listmodels.clear();
    }

    public void save() {
        try {
            System.out.println("save " + this.getFolderTree());
            this.getFolderTree().save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MandelListFolder getChild(MandelListFolder parent, String name) {
        for (MandelListFolder f : parent) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Object getChild(Object parent, int index) {
        Object c = ((MandelListFolder)parent).get(index);
        return c;
    }

    public int getChildCount(Object parent) {
        return ((MandelListFolder)parent).size();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((MandelListFolder)parent).indexOf(child);
    }

    public boolean isLeaf(Object node) {
        MandelListFolder f = (MandelListFolder)node;
        return f.isLeaf() || f.size() == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        if (newValue == null || newValue.toString().isEmpty()) {
            return;
        }
        MandelListFolder f = (MandelListFolder)path.getLastPathComponent();
        f.setName(newValue.toString());
        this.fireTreeNodesChanged(path, null, null);
        try {
            f.save();
        }
        catch (IOException ex) {
            System.out.println("cannot save: " + ex);
        }
    }

    public MandelListFolder getRoot() {
        return this.getFolderTree().getRoot();
    }

    public MandelListTableModel getRootModel() {
        return this.getMandelListModel(this.getRoot());
    }

    public MandelListFolderTreeModel getEffectiveFolderTreeModel() {
        return this;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return ((MandelListFolder)value).getName();
    }

    public boolean isPathEditable(TreePath path) {
        if (!this.isModifiable()) {
            return false;
        }
        return path.getPathCount() != 1;
    }

    public boolean isPathModifiable(TreePath path) {
        MandelListFolder f = (MandelListFolder)path.getLastPathComponent();
        return !f.isLeaf() && this.isModifiable(f);
    }

    public boolean isPathListModifiable(TreePath path) {
        MandelListFolder f = (MandelListFolder)path.getLastPathComponent();
        if (!f.hasMandelList()) {
            return false;
        }
        if (!this.getMandelListModel(f).isModifiable()) {
            return false;
        }
        return this.isListModifiable(f);
    }

    protected boolean isModifiable(MandelListFolder f) {
        return this.isModifiable();
    }

    public boolean isPathTransferable(TreePath path) {
        return true;
    }

    public MandelListTableModel getMandelListModel(Object folder) {
        MandelListFolder f = (MandelListFolder)folder;
        MandelListTableModel m = this.listmodels.get(f);
        if (m == null) {
            this.checkFolder(f);
            if (f.getMandelList() == null) {
                return null;
            }
            m = this.createMandelListModel(f);
            m.setModifiable(this.isListModifiable(f));
            this.listmodels.put(f, m);
        }
        return m;
    }

    protected boolean isListModifiable(MandelListFolder f) {
        return this.isModifiable(f);
    }

    protected void cleanup(MandelListFolder f) {
        this.listmodels.remove(f);
        for (MandelListFolder s : f) {
            this.cleanup(s);
        }
    }

    public void addAll(MandelListFolder f, QualifiedMandelName[] list) {
        MandelListTableModel m = this.getMandelListModel(f);
        if (m == null) {
            throw new IllegalArgumentException(" no list supported for folder " + f.getPath());
        }
        m.addAll(list);
    }

    public void add(MandelListFolder f, QualifiedMandelName name) {
        MandelListTableModel m = this.getMandelListModel(f);
        if (m == null) {
            throw new IllegalArgumentException(" no list supported for folder " + f.getPath());
        }
        m.add(name);
    }

    public void remove(MandelListFolder f, QualifiedMandelName name) {
        MandelListTableModel m = this.getMandelListModel(f);
        if (m == null) {
            throw new IllegalArgumentException(" no list supported for folder " + f.getPath());
        }
        m.remove(name);
    }

    public MandelListFolder insertFolder(String name, MandelListFolder parent) {
        MandelListFolder child = parent.createSubFolder(name);
        if (child != null) {
            int[] newIndexs = new int[]{parent.indexOf(child)};
            this.foldersWereInserted(parent, newIndexs);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        try {
            int i;
            this.moving = true;
            int[] newIndexs = new int[folders.length];
            for (i = 0; i < folders.length; ++i) {
                this.checkFolder(folders[i]);
                if (folders[i].getParent() == parent && index > parent.indexOf(folders[i])) {
                    --index;
                }
                this._removeFolder(folders[i], true);
            }
            for (i = 0; i < folders.length; ++i) {
                newIndexs[i] = index < 0 || index >= parent.size() ? parent.size() : index++;
                parent.add(newIndexs[i], folders[i]);
            }
            this.foldersWereInserted(parent, newIndexs);
        }
        finally {
            this.moving = false;
        }
    }

    public boolean insertFolders(int index, MandelListFolder[] folders, MandelListFolder parent) {
        int[] newIndexs = new int[folders.length];
        boolean add = false;
        for (int i = 0; i < folders.length; ++i) {
            newIndexs[i] = index < 0 || index >= parent.size() ? parent.size() : index++;
            add |= this._insertFolder(newIndexs[i], folders[i], parent);
        }
        if (add) {
            this.foldersWereInserted(parent, newIndexs);
        }
        return add;
    }

    private boolean _insertFolder(int index, MandelListFolder folder, MandelListFolder parent) {
        boolean add = false;
        add = true;
        MandelListFolder dst = parent.createSubFolder(index, folder.getName());
        dst.getMandelList().addAll(folder.getMandelList());
        for (MandelListFolder s : folder) {
            this._insertFolder(dst.size(), s, dst);
        }
        return add;
    }

    protected void _removeFolder(MandelListFolder node, boolean moved) {
        MandelListFolder parent = node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("folder does not have a parent.");
        }
        int[] childIndices = new int[1];
        Object[] removedChildren = new Object[1];
        childIndices[0] = parent.indexOf(node);
        removedChildren[0] = node;
        parent.remove(childIndices[0]);
        this.foldersWereRemoved(parent, childIndices, removedChildren);
        if (!moved) {
            this.foldersWereDeleted(parent, childIndices, removedChildren);
        }
    }

    public void removeFolder(MandelListFolder node) {
        this._removeFolder(node, false);
    }

    public void foldersWereInserted(MandelListFolder node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.get(childIndices[counter]);
            }
            this.fireTreeNodesInserted(MandelListFolderTreeModelSupport.getPathToRoot(node), childIndices, newChildren);
            this.save();
        }
    }

    public void foldersWereRemoved(MandelListFolder node, int[] childIndices, Object[] removedChildren) {
        for (Object o : removedChildren) {
            MandelListFolder f = (MandelListFolder)o;
            this.cleanup(f);
        }
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            this.fireTreeNodesRemoved(MandelListFolderTreeModelSupport.getPathToRoot(node), childIndices, removedChildren);
        }
        this.save();
    }

    protected void foldersWereDeleted(MandelListFolder node, int[] childIndices, Object[] removedChildren) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            this.fireFoldersDeleted(MandelListFolderTreeModelSupport.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void setThumbnailName(MandelListFolder folder, QualifiedMandelName name) {
        this.checkFolder(folder);
        folder.setThumbnailName(name);
        System.out.println("set thumbnail of " + folder.getPath() + " to " + name);
        try {
            folder.save();
        }
        catch (IOException ex) {
            System.out.println("cannot save: " + ex);
        }
        this.fireTreeNodesChanged(MandelListFolderTreeModelSupport.getPathToRoot(folder), null, null);
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isLocalFolder(MandelListFolder f) {
        this.dump(f);
        return f.getMandelListFolderTree() == this.getFolderTree();
    }

    protected void checkFolder(MandelListFolder f) {
        if (!this.isLocalFolder(f)) {
            throw new IllegalArgumentException("none local folder");
        }
    }

    protected void dump(MandelListFolder f) {
    }

    protected MandelListTableModel createMandelListModel(MandelListFolder f) {
        return new TreeMandelListModel(f.getMandelList(), this.getMandelScanner());
    }

    protected abstract MandelScanner getMandelScanner();

    public DropMode getDropMode() {
        return DropMode.ON_OR_INSERT;
    }

    public int getSourceActions() {
        return 3;
    }

    public boolean canImport(DnDTreeModel.TransferSupport info) {
        if (this.isModifiable()) {
            MandelListFolder folder;
            boolean insert;
            DnDTreeModel.DropLocation dl = info.getDropLocation();
            boolean bl = insert = dl.getChildIndex() >= 0;
            if (info.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
                MandelFolderTransferable t;
                if (!this.isPathModifiable(dl.getPath())) {
                    return false;
                }
                if (!insert && folder.isLeaf()) {
                    return false;
                }
                try {
                    t = (MandelFolderTransferable)info.getTransferable().getTransferData(MandelFolderTransferable.folderFlavor);
                }
                catch (Exception e) {
                    return false;
                }
                for (folder = (MandelListFolder)dl.getPath().getLastPathComponent(); folder != null; folder = folder.getParent()) {
                    for (MandelListFolder f : t.getFolders()) {
                        if (f != folder) continue;
                        return false;
                    }
                }
                if (info.getDropAction() == 0x40000000) {
                    info.setDropAction(1);
                }
                return true;
            }
            if (!insert) {
                if (folder.getMandelList() == null) {
                    return false;
                }
                if (!this.isPathListModifiable(dl.getPath())) {
                    return false;
                }
                if (info.isDataFlavorSupported(MandelTransferable.mandelFlavor)) {
                    return true;
                }
                if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                        if (QualifiedMandelName.create(data) != null) {
                            if (info.getDropAction() == 0x40000000) {
                                info.setDropAction(1);
                            }
                            return true;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public Transferable createTransferable(DnDTreeModel.DragLocation loc) {
        TreePath[] paths = loc.getSelectionPaths();
        int cnt = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (!this.isPathTransferable(paths[i])) continue;
            ++cnt;
        }
        if (cnt == 0) {
            return null;
        }
        MandelListFolder[] folders = new MandelListFolder[cnt];
        cnt = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (!this.isPathTransferable(paths[i])) continue;
            folders[cnt++] = (MandelListFolder)paths[i].getLastPathComponent();
        }
        return new MandelFolderTransferable(this.getFolderTree(), folders);
    }

    public boolean importData(DnDTreeModel.TransferSupport info) {
        DnDTreeModel.DropLocation dl = info.getDropLocation();
        TreePath path = dl.getPath();
        boolean insert = dl.getChildIndex() >= 0;
        boolean done = true;
        MandelListFolder folder = (MandelListFolder)path.getLastPathComponent();
        Transferable t = info.getTransferable();
        try {
            MandelFolderTransferable trans = (MandelFolderTransferable)t.getTransferData(MandelFolderTransferable.folderFlavor);
            MandelListFolder[] dropfolders = trans.getFolders();
            if (trans.getSource() != this.getFolderTree() || info.getDropAction() != 2) {
                this.insertFolders(dl.getChildIndex(), dropfolders, folder);
            } else {
                this.moveFolders(dl.getChildIndex(), dropfolders, folder);
                done = false;
            }
        }
        catch (Exception e) {
            this.check(e);
            try {
                MandelTransferable trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor);
                if (trans.getSource() == folder.getMandelList()) {
                    return false;
                }
                QualifiedMandelName[] data = trans.getNames();
                this.addAll(folder, data);
            }
            catch (Exception ey) {
                this.check(ey);
                try {
                    String name = (String)t.getTransferData(DataFlavor.stringFlavor);
                    QualifiedMandelName mn = QualifiedMandelName.create(name);
                    if (mn == null) {
                        return false;
                    }
                    this.add(folder, mn);
                }
                catch (Exception ex) {
                    this.check(ex);
                    return false;
                }
            }
        }
        return done;
    }

    private void check(Exception e) {
        if (!(e instanceof UnsupportedFlavorException)) {
            e.printStackTrace(System.out);
        }
    }

    public void exportDone(Transferable data, int action) {
        MandelFolderTransferable trans = (MandelFolderTransferable)data;
        MandelListFolder[] folders = trans.getFolders();
        if (action == 2 && trans.getSource() != this.getFolderTree()) {
            for (int i = folders.length - 1; i >= 0; --i) {
                this.removeFolder(folders[i]);
            }
        }
    }

    public static String path(TreePath path) {
        String s = ((MandelListFolder)path.getLastPathComponent()).getName();
        if (path.getParentPath() != null) {
            return MandelListFolderTreeModelSupport.path(path.getParentPath()) + "/" + s;
        }
        return s;
    }

    public static TreePath getPathToRoot(MandelListFolder node) {
        if (node.getParent() == null) {
            return new TreePath(node);
        }
        return MandelListFolderTreeModelSupport.getPathToRoot(node.getParent()).pathByAddingChild(node);
    }

    public void addMandelListFolderTreeModelListener(MandelListFolderTreeModelListener l) {
        this.listenerList.add(MandelListFolderTreeModelListener.class, l);
    }

    public void removeMandelListFolderTreeModelListener(MandelListFolderTreeModelListener l) {
        this.listenerList.remove(MandelListFolderTreeModelListener.class, l);
    }

    public MandelListFolderTreeModelListener[] getMandelListFolderTreeModelListeners() {
        return (MandelListFolderTreeModelListener[])this.getListeners(MandelListFolderTreeModelListener.class);
    }

    protected void fireFoldersDeleted(TreePath path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)this, path, childIndices, children);
            }
            ((MandelListFolderTreeModelListener)listeners[i + 1]).foldersDeleted(e);
        }
    }

    protected void fireFoldersDeleted(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MandelListFolderTreeModelListener.class) continue;
            ((MandelListFolderTreeModelListener)listeners[i + 1]).foldersDeleted(e);
        }
    }

    protected class TreeMandelListModel
    extends DefaultMandelListTableModel {
        public TreeMandelListModel(MandelList list, MandelScanner scanner) {
            super(list, scanner);
        }

        public void refresh() {
            super.refresh();
            this.fireTreeStructureChanged();
        }

        public void refresh(Environment env) {
            super.refresh(env);
            this.fireTreeStructureChanged();
        }

        private void fireTreeStructureChanged() {
            TreePath path = new TreePath(MandelListFolderTreeModelSupport.this.getRoot());
            MandelListFolderTreeModelSupport.this.fireTreeStructureChanged(path);
        }
    }
}

