/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.tool.MandelSpecDialog;
import java.awt.Window;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModTimes
extends MandelSpecDialog<ModPanel> {
    private static DateFormat datetime = new SimpleDateFormat("dd.MM.yyyy HH:mm.ss z");
    private static DefaultFormatter textfmt = new DefaultFormatter();

    public ModTimes(Window parent, String name) {
        super(parent, "Modification Times", name, false);
    }

    @Override
    protected ModPanel createPanel(String name, boolean change) {
        return new ModPanel(name);
    }

    public class ModPanel
    extends MandelSpecDialog.Panel {
        private JLabel label;
        private JFormattedTextField modtime;
        private JFormattedTextField infotime;
        private JFormattedTextField rastertime;
        private JFormattedTextField imagetime;

        public ModPanel(String name) {
            super(name, false);
            this.modtime = this.createTextField("File modification time", 1);
            this.infotime = this.createTextField("Area creation time", 2);
            this.rastertime = this.createTextField("Raster creation time", 3);
            this.imagetime = this.createTextField("Image creation time", 4);
            this.addBorder(0, 1, 2, 4);
        }

        public void setData(MandelData data) {
            MandelInfo info = data.getInfo();
            super.setInfo(info);
            if (data.getFile() != null) {
                this.setValue(this.modtime, data.getFile().getLastModified());
            } else {
                this.setValue(this.modtime, 0L);
            }
        }

        protected void _setInfo(MandelInfo info) {
            this.setValue(this.infotime, info.getCreationTime());
            this.setValue(this.rastertime, info.getRasterCreationTime());
            this.setValue(this.imagetime, info.getImageCreationTime());
        }

        private void setValue(JFormattedTextField field, long time) {
            if (time > 0L) {
                field.setEnabled(true);
                DefaultFormatterFactory f = new DefaultFormatterFactory(new DateFormatter(datetime));
                field.setFormatterFactory(f);
                field.setValue(new Date(time));
            } else {
                field.setEnabled(false);
                field.setFormatterFactory(new DefaultFormatterFactory(textfmt));
                field.setValue("Not set");
            }
        }
    }
}

